/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.partition.Member;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.utils.serializer.KryoNamespace;
import io.atomix.utils.serializer.KryoNamespaces;

public enum PrimaryElectorOperations implements OperationId
{
    ENTER(OperationType.COMMAND),
    GET_TERM(OperationType.QUERY);

    private final OperationType type;
    public static final KryoNamespace NAMESPACE;

    private PrimaryElectorOperations(OperationType type) {
        this.type = type;
    }

    public String id() {
        return this.name();
    }

    @Override
    public OperationType type() {
        return this.type;
    }

    static {
        NAMESPACE = KryoNamespace.builder().register(KryoNamespaces.BASIC).nextId(500).register(new Class[]{Enter.class}).register(new Class[]{GetTerm.class}).register(new Class[]{Member.class}).register(new Class[]{NodeId.class}).register(new Class[]{MemberGroupId.class}).register(new Class[]{PartitionId.class}).build(PrimaryElectorOperations.class.getSimpleName());
    }

    public static class Enter
    extends PartitionOperation {
        private Member member;

        Enter() {
        }

        Enter(PartitionId partitionId, Member member) {
            super(partitionId);
            this.member = member;
        }

        public Member member() {
            return this.member;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("partition", (Object)this.partitionId).add("member", (Object)this.member).toString();
        }
    }

    public static class GetTerm
    extends PartitionOperation {
        public GetTerm() {
        }

        public GetTerm(PartitionId partitionId) {
            super(partitionId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("partition", (Object)this.partitionId).toString();
        }
    }

    public static abstract class PartitionOperation
    extends ElectorOperation {
        protected PartitionId partitionId;

        public PartitionOperation() {
        }

        public PartitionOperation(PartitionId partitionId) {
            this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId);
        }

        public PartitionId partitionId() {
            return this.partitionId;
        }
    }

    public static abstract class ElectorOperation {
    }
}

