/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.Node;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupId;
import java.util.Objects;
import java.util.Set;

public class NodeMemberGroup
implements MemberGroup {
    private final MemberGroupId groupId;
    private final Set<Node> nodes;

    public NodeMemberGroup(MemberGroupId groupId, Set<Node> nodes) {
        this.groupId = (MemberGroupId)((Object)Preconditions.checkNotNull((Object)((Object)groupId)));
        this.nodes = (Set)Preconditions.checkNotNull(nodes);
    }

    @Override
    public MemberGroupId id() {
        return this.groupId;
    }

    @Override
    public boolean isMember(Node node) {
        return this.nodes.contains(node);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.nodes});
    }

    public boolean equals(Object object) {
        if (object instanceof NodeMemberGroup) {
            NodeMemberGroup memberGroup = (NodeMemberGroup)object;
            return memberGroup.groupId.equals((Object)this.groupId) && memberGroup.nodes.equals(this.nodes);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.groupId).add("nodes", this.nodes).toString();
    }
}

