/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.primitive.partition.ManagedPrimaryElection;
import io.atomix.primitive.partition.ManagedPrimaryElectionService;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEvent;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryElectionService;
import io.atomix.primitive.partition.impl.DefaultPrimaryElection;
import io.atomix.primitive.partition.impl.PrimaryElectorEvents;
import io.atomix.primitive.partition.impl.PrimaryElectorOperations;
import io.atomix.primitive.partition.impl.PrimaryElectorType;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.utils.event.Event;
import io.atomix.utils.serializer.KryoNamespace;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class DefaultPrimaryElectionService
implements ManagedPrimaryElectionService {
    private static final String PRIMITIVE_NAME = "atomix-primary-elector";
    private static final Serializer SERIALIZER = Serializer.using((Namespace)KryoNamespace.builder().register(PrimaryElectorOperations.NAMESPACE).register(PrimaryElectorEvents.NAMESPACE).build());
    private final PartitionGroup<?> partitions;
    private final Set<PrimaryElectionEventListener> listeners = Sets.newCopyOnWriteArraySet();
    private final Consumer<PrimaryElectionEvent> eventListener = event -> this.listeners.forEach(l -> l.onEvent((Event)event));
    private final Map<PartitionId, ManagedPrimaryElection> elections = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();
    private PrimitiveProxy proxy;

    public DefaultPrimaryElectionService(PartitionGroup<?> partitionGroup) {
        this.partitions = (PartitionGroup)Preconditions.checkNotNull(partitionGroup);
    }

    @Override
    public PrimaryElection getElectionFor(PartitionId partitionId) {
        return this.elections.computeIfAbsent(partitionId, id -> new DefaultPrimaryElection(partitionId, this.proxy, this));
    }

    public void addListener(PrimaryElectionEventListener listener) {
        this.listeners.add((PrimaryElectionEventListener)Preconditions.checkNotNull((Object)listener));
    }

    public void removeListener(PrimaryElectionEventListener listener) {
        this.listeners.remove(Preconditions.checkNotNull((Object)listener));
    }

    public CompletableFuture<PrimaryElectionService> start() {
        return ((CompletableFuture)this.partitions.getPartitions().iterator().next().getPrimitiveClient().newProxy(PRIMITIVE_NAME, PrimaryElectorType.instance()).connect().thenAccept(proxy -> {
            this.proxy = proxy;
            proxy.addEventListener(PrimaryElectorEvents.CHANGE, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this.eventListener);
            this.started.set(true);
        })).thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        PrimitiveProxy proxy = this.proxy;
        if (proxy != null) {
            return proxy.close().whenComplete((result, error) -> this.started.set(false));
        }
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

