/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.DelegatingPrimitiveProxy;
import io.atomix.utils.concurrent.Futures;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class BlockingAwarePrimitiveProxy
extends DelegatingPrimitiveProxy {
    private final Executor executor;
    private final Map<Consumer<PrimitiveProxy.State>, Consumer<PrimitiveProxy.State>> stateChangeListeners = Maps.newConcurrentMap();
    private final Map<Consumer<PrimitiveEvent>, Consumer<PrimitiveEvent>> eventListeners = Maps.newConcurrentMap();

    public BlockingAwarePrimitiveProxy(PrimitiveProxy delegate, Executor executor) {
        super(delegate);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        Consumer<PrimitiveProxy.State> wrappedListener = state -> this.executor.execute(() -> listener.accept((PrimitiveProxy.State)((Object)state)));
        this.stateChangeListeners.put(listener, wrappedListener);
        super.addStateChangeListener(wrappedListener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        Consumer<PrimitiveProxy.State> wrappedListener = this.stateChangeListeners.remove(listener);
        if (wrappedListener != null) {
            super.removeStateChangeListener(wrappedListener);
        }
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        return Futures.blockingAwareFuture(super.execute(operation), (Executor)this.executor);
    }

    @Override
    public void addEventListener(Consumer<PrimitiveEvent> listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> this.executor.execute(() -> listener.accept((PrimitiveEvent)e));
        this.eventListeners.put(listener, wrappedListener);
        super.addEventListener(wrappedListener);
    }

    @Override
    public void removeEventListener(Consumer<PrimitiveEvent> listener) {
        Consumer<PrimitiveEvent> wrappedListener = this.eventListeners.remove(listener);
        if (wrappedListener != null) {
            super.removeEventListener(wrappedListener);
        }
    }
}

