/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.collect.Maps;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionService
implements ManagedPartitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionService.class);
    private final Map<String, ManagedPartitionGroup> groups = Maps.newConcurrentMap();

    public DefaultPartitionService(Collection<ManagedPartitionGroup> groups) {
        groups.forEach(g -> this.groups.put(g.name(), (ManagedPartitionGroup)g));
    }

    @Override
    public PartitionGroup getPartitionGroup(String name) {
        return this.groups.get(name);
    }

    @Override
    public Collection<PartitionGroup> getPartitionGroups() {
        return this.groups.values();
    }

    @Override
    public CompletableFuture<PartitionService> open(PartitionManagementService managementService) {
        List<CompletableFuture> futures = this.groups.values().stream().map(g -> g.open(managementService)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.groups.values().stream().map(ManagedPartitionGroup::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> LOGGER.info("Stopped"));
    }
}

