/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.Consistency;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.impl.DefaultProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.protocols.backup.MultiPrimaryProtocolConfig;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MultiPrimaryProtocol
implements PrimitiveProtocol {
    public static final Type TYPE = new Type();
    protected final MultiPrimaryProtocolConfig config;

    public static Builder builder() {
        return new Builder(new MultiPrimaryProtocolConfig());
    }

    public static Builder builder(String group) {
        return new Builder((MultiPrimaryProtocolConfig)new MultiPrimaryProtocolConfig().setGroup(group));
    }

    protected MultiPrimaryProtocol(MultiPrimaryProtocolConfig config) {
        this.config = config;
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.config.getGroup();
    }

    public <S> ProxyClient<S> newProxy(String primitiveName, PrimitiveType primitiveType, Class<S> serviceType, ServiceConfig serviceConfig, PartitionService partitionService) {
        Collection partitions = partitionService.getPartitionGroup((PrimitiveProtocol)this).getPartitions().stream().map(partition -> (SessionClient)((PrimaryBackupPartition)partition).getClient().sessionBuilder(primitiveName, primitiveType, serviceConfig).withConsistency(this.config.getConsistency()).withReplication(this.config.getReplication()).withRecovery(this.config.getRecovery()).withNumBackups(this.config.getBackups()).withMaxRetries(this.config.getMaxRetries()).withRetryDelay(this.config.getRetryDelay()).build()).collect(Collectors.toList());
        return new DefaultProxyClient(primitiveName, primitiveType, (PrimitiveProtocol)this, serviceType, partitions, this.config.getPartitioner());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type()).add("group", (Object)this.group()).toString();
    }

    public static class Builder
    extends PrimitiveProtocol.Builder<MultiPrimaryProtocolConfig, MultiPrimaryProtocol> {
        protected Builder(MultiPrimaryProtocolConfig config) {
            super((PrimitiveProtocolConfig)config);
        }

        public Builder withPartitioner(Partitioner<String> partitioner) {
            ((MultiPrimaryProtocolConfig)this.config).setPartitioner(partitioner);
            return this;
        }

        public Builder withConsistency(Consistency consistency) {
            ((MultiPrimaryProtocolConfig)this.config).setConsistency(consistency);
            return this;
        }

        public Builder withReplication(Replication replication) {
            ((MultiPrimaryProtocolConfig)this.config).setReplication(replication);
            return this;
        }

        public Builder withRecovery(Recovery recovery) {
            ((MultiPrimaryProtocolConfig)this.config).setRecovery(recovery);
            return this;
        }

        public Builder withBackups(int numBackups) {
            ((MultiPrimaryProtocolConfig)this.config).setBackups(numBackups);
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            ((MultiPrimaryProtocolConfig)this.config).setMaxRetries(maxRetries);
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            ((MultiPrimaryProtocolConfig)this.config).setRetryDelayMillis(retryDelayMillis);
            return this;
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            ((MultiPrimaryProtocolConfig)this.config).setRetryDelay(retryDelay);
            return this;
        }

        public MultiPrimaryProtocol build() {
            return new MultiPrimaryProtocol((MultiPrimaryProtocolConfig)this.config);
        }
    }

    public static final class Type
    implements PrimitiveProtocol.Type<MultiPrimaryProtocolConfig> {
        private static final String NAME = "multi-primary";

        public String name() {
            return NAME;
        }

        public MultiPrimaryProtocolConfig newConfig() {
            return new MultiPrimaryProtocolConfig();
        }

        public PrimitiveProtocol newProtocol(MultiPrimaryProtocolConfig config) {
            return new MultiPrimaryProtocol(config);
        }
    }
}

