/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.messaging.ClusterMessagingService;
import io.atomix.messaging.MessagingException;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupMessageContext;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.CloseResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.MetadataRequest;
import io.atomix.protocols.backup.protocol.MetadataResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupClientProtocol;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class PrimaryBackupClientCommunicator
implements PrimaryBackupClientProtocol {
    private final PrimaryBackupMessageContext context;
    private final Serializer serializer;
    private final ClusterMessagingService clusterCommunicator;

    public PrimaryBackupClientCommunicator(String prefix, Serializer serializer, ClusterMessagingService clusterCommunicator) {
        this.context = new PrimaryBackupMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterMessagingService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, NodeId nodeId) {
        CompletableFuture future = new CompletableFuture();
        this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), nodeId).whenComplete((result, error) -> {
            if (error == null) {
                future.complete(result);
            } else {
                Throwable cause = Throwables.getRootCause((Throwable)error);
                if (cause instanceof MessagingException.NoRemoteHandler) {
                    future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ExecuteResponse> execute(NodeId nodeId, ExecuteRequest request) {
        return this.sendAndReceive(this.context.executeSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(NodeId nodeId, MetadataRequest request) {
        return this.sendAndReceive(this.context.metadataSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<CloseResponse> close(NodeId nodeId, CloseRequest request) {
        return this.sendAndReceive(this.context.closeSubject, request, nodeId);
    }

    @Override
    public void registerEventListener(SessionId sessionId, Consumer<PrimitiveEvent> listener, Executor executor) {
        this.clusterCommunicator.subscribe(this.context.eventSubject((Long)sessionId.id()), arg_0 -> ((Serializer)this.serializer).decode(arg_0), listener, executor);
    }

    @Override
    public void unregisterEventListener(SessionId sessionId) {
        this.clusterCommunicator.unsubscribe(this.context.eventSubject((Long)sessionId.id()));
    }
}

