/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterService;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.partition.ManagedMemberGroupService;
import io.atomix.primitive.partition.Member;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupService;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.CloseResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.MetadataRequest;
import io.atomix.protocols.backup.protocol.MetadataResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.protocols.backup.protocol.PrimitiveRequest;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class PrimaryBackupServerContext
implements Managed<Void> {
    private final String serverName;
    private final ClusterService clusterService;
    private final ManagedMemberGroupService memberGroupService;
    private final PrimaryBackupServerProtocol protocol;
    private final ThreadContextFactory threadContextFactory;
    private final PrimitiveTypeRegistry primitiveTypes;
    private final PrimaryElection primaryElection;
    private final Map<String, CompletableFuture<PrimaryBackupServiceContext>> services = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();

    public PrimaryBackupServerContext(String serverName, ClusterService clusterService, ManagedMemberGroupService memberGroupService, PrimaryBackupServerProtocol protocol, ThreadContextFactory threadContextFactory, PrimitiveTypeRegistry primitiveTypes, PrimaryElection primaryElection) {
        this.serverName = serverName;
        this.clusterService = clusterService;
        this.memberGroupService = memberGroupService;
        this.protocol = protocol;
        this.threadContextFactory = threadContextFactory;
        this.primitiveTypes = primitiveTypes;
        this.primaryElection = primaryElection;
    }

    public PrimaryBackupServer.Role getRole() {
        return Objects.equals(((PrimaryTerm)this.primaryElection.getTerm().join()).primary().nodeId(), this.clusterService.getLocalNode().id()) ? PrimaryBackupServer.Role.PRIMARY : PrimaryBackupServer.Role.BACKUP;
    }

    public CompletableFuture<Void> start() {
        this.registerListeners();
        this.started.set(true);
        return ((CompletableFuture)this.memberGroupService.start().thenCompose(v -> {
            MemberGroup group = this.memberGroupService.getMemberGroup(this.clusterService.getLocalNode());
            if (group != null) {
                return this.primaryElection.enter(new Member(this.clusterService.getLocalNode().id(), group.id()));
            }
            return CompletableFuture.completedFuture(null);
        })).thenApply(v -> null);
    }

    private CompletableFuture<ExecuteResponse> execute(ExecuteRequest request) {
        return this.getService(request).thenCompose(service -> service.execute(request));
    }

    private CompletableFuture<BackupResponse> backup(BackupRequest request) {
        return this.getService(request).thenCompose(service -> service.backup(request));
    }

    private CompletableFuture<RestoreResponse> restore(RestoreRequest request) {
        return this.getService(request).thenCompose(service -> service.restore(request));
    }

    private CompletableFuture<CloseResponse> close(CloseRequest request) {
        return this.getService(request).thenCompose(service -> service.close(request));
    }

    private CompletableFuture<PrimaryBackupServiceContext> getService(PrimitiveRequest request) {
        return this.services.computeIfAbsent(request.primitive().name(), n -> {
            PrimaryBackupServiceContext service = new PrimaryBackupServiceContext(this.serverName, PrimitiveId.from((String)request.primitive().name()), this.primitiveTypes.get(request.primitive().type()), request.primitive(), this.threadContextFactory.createContext(), this.clusterService, (MemberGroupService)this.memberGroupService, this.protocol, this.primaryElection);
            return service.open().thenApply(v -> service);
        });
    }

    private CompletableFuture<MetadataResponse> metadata(MetadataRequest request) {
        return CompletableFuture.completedFuture(MetadataResponse.ok(this.services.entrySet().stream().filter(entry -> ((PrimaryBackupServiceContext)((CompletableFuture)entry.getValue()).join()).serviceType().id().equals(request.primitiveType())).map(entry -> (String)entry.getKey()).collect(Collectors.toSet())));
    }

    private void registerListeners() {
        this.protocol.registerExecuteHandler(this::execute);
        this.protocol.registerBackupHandler(this::backup);
        this.protocol.registerRestoreHandler(this::restore);
        this.protocol.registerCloseHandler(this::close);
        this.protocol.registerMetadataHandler(this::metadata);
    }

    private void unregisterListeners() {
        this.protocol.unregisterExecuteHandler();
        this.protocol.unregisterBackupHandler();
        this.protocol.unregisterRestoreHandler();
        this.protocol.unregisterCloseHandler();
        this.protocol.unregisterMetadataHandler();
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        this.unregisterListeners();
        this.started.set(false);
        return this.memberGroupService.stop();
    }
}

