/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

import io.atomix.primitive.PrimitiveClient;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.PrimaryBackupClient;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupClientCommunicator;
import io.atomix.protocols.backup.serializer.impl.PrimaryBackupNamespaces;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionClient
implements PrimitiveClient<MultiPrimaryProtocol>,
Managed<PrimaryBackupPartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PrimaryBackupPartition partition;
    private final PartitionManagementService managementService;
    private final ThreadContextFactory threadFactory;
    private PrimaryBackupClient client;

    public PrimaryBackupPartitionClient(PrimaryBackupPartition partition, PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.partition = partition;
        this.managementService = managementService;
        this.threadFactory = threadFactory;
    }

    public PrimitiveProxy newProxy(String primitiveName, PrimitiveType primitiveType, MultiPrimaryProtocol primitiveProtocol) {
        return this.client.newProxy(primitiveName, primitiveType, primitiveProtocol);
    }

    public CompletableFuture<Set<String>> getPrimitives(PrimitiveType primitiveType) {
        return this.client.getPrimitives(primitiveType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PrimaryBackupPartitionClient> start() {
        PrimaryBackupPartitionClient primaryBackupPartitionClient = this;
        synchronized (primaryBackupPartitionClient) {
            this.client = this.newClient();
            this.log.info("Successfully started client for {}", (Object)this.partition.id());
        }
        return CompletableFuture.completedFuture(this);
    }

    private PrimaryBackupClient newClient() {
        return PrimaryBackupClient.builder().withClientName(this.partition.name()).withClusterService(this.managementService.getClusterService()).withProtocol(new PrimaryBackupClientCommunicator(this.partition.name(), Serializer.using((Namespace)PrimaryBackupNamespaces.PROTOCOL), this.managementService.getCommunicationService())).withPrimaryElection(this.managementService.getElectionService().getElectionFor(this.partition.id())).withSessionIdProvider(this.managementService.getSessionIdService()).withThreadContextFactory(this.threadFactory).build();
    }

    public boolean isRunning() {
        return this.client != null;
    }

    public CompletableFuture<Void> stop() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }
}

