/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.protocols.backup.impl.PrimaryBackupServerContext;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class PrimaryBackupServer
implements Managed<PrimaryBackupServer> {
    private final PrimaryBackupServerContext context;
    private final AtomicBoolean open = new AtomicBoolean();

    public static Builder builder() {
        return new Builder();
    }

    public PrimaryBackupServer(PrimaryBackupServerContext context) {
        this.context = (PrimaryBackupServerContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
    }

    public Role getRole() {
        return this.context.getRole();
    }

    public CompletableFuture<PrimaryBackupServer> start() {
        this.context.open();
        this.open.set(true);
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.open.get();
    }

    public CompletableFuture<Void> stop() {
        this.open.set(false);
        this.context.close();
        return CompletableFuture.completedFuture(null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<PrimaryBackupServer> {
        protected String serverName = "atomix";
        protected ClusterService clusterService;
        protected PrimaryBackupServerProtocol protocol;
        protected PrimaryElection primaryElection;
        protected PrimitiveTypeRegistry primitiveTypes = new PrimitiveTypeRegistry();
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Runtime.getRuntime().availableProcessors();
        protected ThreadContextFactory threadContextFactory;

        public Builder withServerName(String serverName) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"server cannot be null");
            return this;
        }

        public Builder withClusterService(ClusterService clusterService) {
            this.clusterService = (ClusterService)Preconditions.checkNotNull((Object)clusterService, (Object)"clusterService cannot be null");
            return this;
        }

        public Builder withProtocol(PrimaryBackupServerProtocol protocol) {
            this.protocol = (PrimaryBackupServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withPrimaryElection(PrimaryElection primaryElection) {
            this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection, (Object)"primaryElection cannot be null");
            return this;
        }

        public Builder withPrimitiveTypes(PrimitiveTypeRegistry primitiveTypes) {
            this.primitiveTypes = (PrimitiveTypeRegistry)Preconditions.checkNotNull((Object)primitiveTypes, (Object)"primitiveTypes cannot be null");
            return this;
        }

        public Builder addPrimitiveType(PrimitiveType primitiveType) {
            this.primitiveTypes.register(primitiveType);
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public PrimaryBackupServer build() {
            ContextualLogger log = ContextualLoggerFactory.getLogger(PrimaryBackupServer.class, (LoggerContext)LoggerContext.builder(PrimaryBackupServer.class).addValue((Object)this.serverName).build());
            ThreadContextFactory threadContextFactory = this.threadContextFactory != null ? this.threadContextFactory : this.threadModel.factory("backup-server-" + this.serverName + "-%d", this.threadPoolSize, (Logger)log);
            return new PrimaryBackupServer(new PrimaryBackupServerContext(this.serverName, this.clusterService, this.protocol, threadContextFactory, this.primitiveTypes, this.primaryElection));
        }
    }

    public static enum Role {
        PRIMARY,
        BACKUP,
        NONE;

    }
}

