/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition;

import com.google.common.base.Preconditions;
import io.atomix.primitive.partition.MemberGroupStrategy;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.protocols.log.partition.LogCompactionConfig;
import io.atomix.protocols.log.partition.LogPartitionGroup;
import io.atomix.protocols.log.partition.LogStorageConfig;

public class LogPartitionGroupConfig
extends PartitionGroupConfig<LogPartitionGroupConfig> {
    private static final int DEFAULT_PARTITIONS = 7;
    private String memberGroupStrategy = MemberGroupStrategy.NODE_AWARE.name();
    private LogStorageConfig storageConfig = new LogStorageConfig();
    private LogCompactionConfig compactionConfig = new LogCompactionConfig();

    public PartitionGroup.Type getType() {
        return LogPartitionGroup.TYPE;
    }

    protected int getDefaultPartitions() {
        return 7;
    }

    public MemberGroupStrategy getMemberGroupProvider() {
        return MemberGroupStrategy.valueOf((String)this.memberGroupStrategy);
    }

    public LogPartitionGroupConfig setMemberGroupStrategy(MemberGroupStrategy memberGroupStrategy) {
        this.memberGroupStrategy = memberGroupStrategy.name();
        return this;
    }

    public LogStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public LogPartitionGroupConfig setStorageConfig(LogStorageConfig storageConfig) {
        this.storageConfig = (LogStorageConfig)Preconditions.checkNotNull((Object)storageConfig, (Object)"storageConfig cannot be null");
        return this;
    }

    public LogCompactionConfig getCompactionConfig() {
        return this.compactionConfig;
    }

    public LogPartitionGroupConfig setCompactionConfig(LogCompactionConfig compactionConfig) {
        this.compactionConfig = (LogCompactionConfig)Preconditions.checkNotNull((Object)compactionConfig, (Object)"compactionConfig cannot be null");
        return this;
    }
}

