/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.counter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicLongMap;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.counter.CounterDelegate;
import io.atomix.protocols.gossip.CrdtProtocolConfig;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CrdtCounterDelegate
implements CounterDelegate {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).register(new Class[]{MemberId.class}).build());
    private final MemberId localMemberId;
    private final ClusterCommunicationService clusterCommunicator;
    private final ScheduledExecutorService executorService;
    private final String subject;
    private volatile ScheduledFuture<?> broadcastFuture;
    private final AtomicLongMap<MemberId> increments = AtomicLongMap.create();
    private final AtomicLongMap<MemberId> decrements = AtomicLongMap.create();

    public CrdtCounterDelegate(String name, CrdtProtocolConfig config, PrimitiveManagementService managementService) {
        this.localMemberId = managementService.getMembershipService().getLocalMember().id();
        this.clusterCommunicator = managementService.getCommunicationService();
        this.executorService = managementService.getExecutorService();
        this.subject = String.format("atomix-crdt-counter-%s", name);
        this.clusterCommunicator.subscribe(this.subject, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::updateCounters, (Executor)this.executorService);
        this.broadcastFuture = this.executorService.scheduleAtFixedRate(this::broadcastCounters, config.getGossipInterval().toMillis(), config.getGossipInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public long get() {
        return this.increments.sum() - this.decrements.sum();
    }

    public long incrementAndGet() {
        return this.getIncrement(this.increments.incrementAndGet((Object)this.localMemberId));
    }

    public long decrementAndGet() {
        return this.getDecrement(this.decrements.incrementAndGet((Object)this.localMemberId));
    }

    public long getAndIncrement() {
        return this.getIncrement(this.increments.getAndIncrement((Object)this.localMemberId));
    }

    public long getAndDecrement() {
        return this.getDecrement(this.decrements.getAndIncrement((Object)this.localMemberId));
    }

    public long getAndAdd(long delta) {
        return this.getIncrement(this.increments.getAndAdd((Object)this.localMemberId, delta));
    }

    public long addAndGet(long delta) {
        return this.getIncrement(this.increments.addAndGet((Object)this.localMemberId, delta));
    }

    private long getIncrement(long local) {
        return this.increments.asMap().entrySet().stream().filter(e -> !((MemberId)e.getKey()).equals((Object)this.localMemberId)).mapToLong(e -> (Long)e.getValue()).sum() + local - this.decrements.sum();
    }

    private long getDecrement(long local) {
        return this.increments.sum() - (this.decrements.asMap().entrySet().stream().filter(e -> !((MemberId)e.getKey()).equals((Object)this.localMemberId)).mapToLong(e -> (Long)e.getValue()).sum() + local);
    }

    private void updateCounters(List<Map<MemberId, Long>> counters) {
        Map<MemberId, Long> increments = counters.get(0);
        for (Map.Entry<MemberId, Long> entry : increments.entrySet()) {
            this.increments.accumulateAndGet((Object)entry.getKey(), entry.getValue().longValue(), Math::max);
        }
        Map<MemberId, Long> decrements = counters.get(1);
        for (Map.Entry<MemberId, Long> entry : decrements.entrySet()) {
            this.decrements.accumulateAndGet((Object)entry.getKey(), entry.getValue().longValue(), Math::max);
        }
    }

    private void broadcastCounters() {
        ArrayList changes = Lists.newArrayList((Object[])new Map[]{Maps.newHashMap((Map)this.increments.asMap()), Maps.newHashMap((Map)this.decrements.asMap())});
        this.clusterCommunicator.broadcast(this.subject, (Object)changes, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    public void close() {
        this.broadcastFuture.cancel(false);
        this.clusterCommunicator.unsubscribe(this.subject);
    }
}

