/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.concurrent;

import io.atomix.catalyst.concurrent.BlockingFuture;
import io.atomix.concurrent.internal.LockCommands;
import io.atomix.concurrent.util.DistributedLockFactory;
import io.atomix.copycat.Command;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@ResourceTypeInfo(id=-22, factory=DistributedLockFactory.class)
public class DistributedLock
extends AbstractResource<DistributedLock> {
    private final Map<Integer, CompletableFuture<Long>> futures = new ConcurrentHashMap<Integer, CompletableFuture<Long>>();
    private final AtomicInteger id = new AtomicInteger();
    private int lock;

    public DistributedLock(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<DistributedLock> open() {
        return super.open().thenApply(result -> {
            this.client.onEvent("lock", this::handleEvent);
            this.client.onEvent("fail", this::handleFail);
            return result;
        });
    }

    private void handleEvent(LockCommands.LockEvent event) {
        CompletableFuture<Long> future = this.futures.remove(event.id());
        if (future != null) {
            this.lock = event.id();
            future.complete(event.version());
        }
    }

    private void handleFail(LockCommands.LockEvent event) {
        CompletableFuture<Long> future = this.futures.remove(event.id());
        if (future != null) {
            future.complete(null);
        }
    }

    public CompletableFuture<Long> lock() {
        BlockingFuture future = new BlockingFuture();
        int id = this.id.incrementAndGet();
        this.futures.put(id, (CompletableFuture<Long>)future);
        this.client.submit((Command)new LockCommands.Lock(id, -1L)).whenComplete((arg_0, arg_1) -> this.lambda$lock$1(id, (CompletableFuture)future, arg_0, arg_1));
        return future;
    }

    public CompletableFuture<Long> tryLock() {
        BlockingFuture future = new BlockingFuture();
        int id = this.id.incrementAndGet();
        this.futures.put(id, (CompletableFuture<Long>)future);
        this.client.submit((Command)new LockCommands.Lock(id, 0L)).whenComplete((arg_0, arg_1) -> this.lambda$tryLock$2(id, (CompletableFuture)future, arg_0, arg_1));
        return future;
    }

    public CompletableFuture<Long> tryLock(Duration timeout) {
        BlockingFuture future = new BlockingFuture();
        int id = this.id.incrementAndGet();
        this.futures.put(id, (CompletableFuture<Long>)future);
        this.client.submit((Command)new LockCommands.Lock(id, timeout.toMillis())).whenComplete((arg_0, arg_1) -> this.lambda$tryLock$3(id, (CompletableFuture)future, arg_0, arg_1));
        return future;
    }

    public CompletableFuture<Void> unlock() {
        int lock = this.lock;
        this.lock = 0;
        if (lock != 0) {
            return this.client.submit((Command)new LockCommands.Unlock(lock));
        }
        return CompletableFuture.completedFuture(null);
    }

    private /* synthetic */ void lambda$tryLock$3(int id, CompletableFuture future, Void result, Throwable error) {
        if (error != null) {
            this.futures.remove(id);
            future.completeExceptionally(error);
        }
    }

    private /* synthetic */ void lambda$tryLock$2(int id, CompletableFuture future, Void result, Throwable error) {
        if (error != null) {
            this.futures.remove(id);
            future.completeExceptionally(error);
        }
    }

    private /* synthetic */ void lambda$lock$1(int id, CompletableFuture future, Void result, Throwable error) {
        if (error != null) {
            this.futures.remove(id);
            future.completeExceptionally(error);
        }
    }
}

