/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberBuilder;
import io.atomix.cluster.MemberConfig;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.utils.Version;
import io.atomix.utils.net.Address;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class Member
extends Node {
    private final MemberId id;
    private final String zone;
    private final String rack;
    private final String host;
    private final Properties properties;

    public static MemberBuilder builder() {
        return new MemberBuilder(new MemberConfig());
    }

    public static MemberBuilder builder(String memberId) {
        return Member.builder(MemberId.from(memberId));
    }

    public static MemberBuilder builder(MemberId memberId) {
        return Member.builder().withId(memberId);
    }

    public static Member member(String address) {
        return Member.member(Address.from((String)address));
    }

    public static Member member(String name, String address) {
        return Member.member(MemberId.from(name), Address.from((String)address));
    }

    public static Member member(Address address) {
        return Member.builder().withAddress(address).build();
    }

    public static Member member(MemberId memberId, Address address) {
        return Member.builder(memberId).withAddress(address).build();
    }

    public Member(MemberConfig config) {
        super(config);
        this.id = config.getId();
        this.zone = config.getZoneId();
        this.rack = config.getRackId();
        this.host = config.getHostId();
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)config.getProperties());
    }

    protected Member(MemberId id, Address address) {
        this(id, address, null, null, null, new Properties());
    }

    protected Member(MemberId id, Address address, String zone, String rack, String host, Properties properties) {
        super(id, address);
        this.id = (MemberId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.zone = zone;
        this.rack = rack;
        this.host = host;
        this.properties = properties;
    }

    @Override
    public MemberId id() {
        return this.id;
    }

    public boolean isActive() {
        return false;
    }

    public boolean isReachable() {
        return false;
    }

    public String zone() {
        return this.zone;
    }

    public String rack() {
        return this.rack;
    }

    public String host() {
        return this.host;
    }

    public Properties properties() {
        return this.properties;
    }

    public Version version() {
        return null;
    }

    public long timestamp() {
        return 0L;
    }

    @Override
    public MemberConfig config() {
        return new MemberConfig().setId(this.id()).setAddress(this.address()).setZoneId(this.zone()).setRackId(this.rack()).setHostId(this.host()).setProperties(this.properties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id(), this.address(), this.zone(), this.rack(), this.host(), this.properties());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Member) {
            Member member = (Member)object;
            return member.id().equals(this.id()) && member.address().equals((Object)this.address()) && Objects.equals(member.zone(), this.zone()) && Objects.equals(member.rack(), this.rack()) && Objects.equals(member.host(), this.host()) && Objects.equals(member.properties(), this.properties());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(Member.class).add("id", (Object)this.id()).add("address", (Object)this.address()).add("zone", (Object)this.zone()).add("rack", (Object)this.rack()).add("host", (Object)this.host()).add("properties", (Object)this.properties()).omitNullValues().toString();
    }
}

