/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.ProtocolMessage;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageEncoderV1
extends MessageToByteEncoder<Object> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Address address;
    private boolean addressWritten;

    MessageEncoderV1(Address address) {
        this.address = address;
    }

    protected void encode(ChannelHandlerContext context, Object rawMessage, ByteBuf out) throws Exception {
        if (rawMessage instanceof ProtocolRequest) {
            this.encodeRequest((ProtocolRequest)rawMessage, out);
        } else if (rawMessage instanceof ProtocolReply) {
            this.encodeReply((ProtocolReply)rawMessage, out);
        }
    }

    private void encodeMessage(ProtocolMessage message, ByteBuf buffer) {
        if (!this.addressWritten) {
            InetAddress senderIp = this.address.address();
            byte[] senderIpBytes = senderIp.getAddress();
            buffer.writeByte(senderIpBytes.length);
            buffer.writeBytes(senderIpBytes);
            buffer.writeInt(this.address.port());
            this.addressWritten = true;
        }
        buffer.writeByte(message.type().id());
        MessageEncoderV1.writeLong(buffer, message.id());
        byte[] payload = message.payload();
        MessageEncoderV1.writeInt(buffer, payload.length);
        buffer.writeBytes(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeRequest(ProtocolRequest request, ByteBuf out) {
        this.encodeMessage(request, out);
        ByteBuf buf = out.alloc().buffer(ByteBufUtil.utf8MaxBytes((CharSequence)request.subject()));
        try {
            int length = ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)request.subject());
            out.writeShort(length);
            out.writeBytes(buf);
        }
        finally {
            buf.release();
        }
    }

    private void encodeReply(ProtocolReply reply, ByteBuf out) {
        this.encodeMessage(reply, out);
        out.writeByte(reply.status().id());
    }

    static void writeInt(ByteBuf buf, int value) {
        if (value >>> 7 == 0) {
            buf.writeByte(value);
        } else if (value >>> 14 == 0) {
            buf.writeByte(value & 0x7F | 0x80);
            buf.writeByte(value >>> 7);
        } else if (value >>> 21 == 0) {
            buf.writeByte(value & 0x7F | 0x80);
            buf.writeByte(value >>> 7 | 0x80);
            buf.writeByte(value >>> 14);
        } else if (value >>> 28 == 0) {
            buf.writeByte(value & 0x7F | 0x80);
            buf.writeByte(value >>> 7 | 0x80);
            buf.writeByte(value >>> 14 | 0x80);
            buf.writeByte(value >>> 21);
        } else {
            buf.writeByte(value & 0x7F | 0x80);
            buf.writeByte(value >>> 7 | 0x80);
            buf.writeByte(value >>> 14 | 0x80);
            buf.writeByte(value >>> 21 | 0x80);
            buf.writeByte(value >>> 28);
        }
    }

    static void writeLong(ByteBuf buf, long value) {
        if (value >>> 7 == 0L) {
            buf.writeByte((int)((byte)value));
        } else if (value >>> 14 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7)));
        } else if (value >>> 21 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14)));
        } else if (value >>> 28 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 21)));
        } else if (value >>> 35 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 28)));
        } else if (value >>> 42 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 35)));
        } else if (value >>> 49 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 42)));
        } else if (value >>> 56 == 0L) {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 42 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 49)));
        } else {
            buf.writeByte((int)((byte)(value & 0x7FL | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 7 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 14 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 21 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 28 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 35 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 42 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 49 | 0x80L)));
            buf.writeByte((int)((byte)(value >>> 56)));
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        try {
            if (cause instanceof IOException) {
                this.log.debug("IOException inside channel handling pipeline.", cause);
            } else {
                this.log.error("non-IOException inside channel handling pipeline.", cause);
            }
        }
        finally {
            context.close();
        }
    }

    public final boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof ProtocolMessage;
    }
}

