/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.cluster.impl.AddressSerializer;
import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.cluster.messaging.UnicastService;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMaxBytesRecvByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUnicastService
implements ManagedUnicastService {
    private static final io.atomix.utils.serializer.Serializer SERIALIZER = io.atomix.utils.serializer.Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).nextId(500).register(new Class[]{Message.class}).register((Serializer)new AddressSerializer(), new Class[]{Address.class}).build());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Address address;
    private EventLoopGroup group;
    private DatagramChannel channel;
    private final Map<String, Map<BiConsumer<Address, byte[]>, Executor>> listeners = Maps.newConcurrentMap();
    private final AtomicBoolean started = new AtomicBoolean();

    public static Builder builder() {
        return new Builder();
    }

    public NettyUnicastService(Address address) {
        this.address = address;
    }

    @Override
    public void unicast(Address address, String subject, byte[] payload) {
        Message message = new Message(this.address, subject, payload);
        byte[] bytes = SERIALIZER.encode((Object)message);
        ByteBuf buf = this.channel.alloc().buffer(4 + bytes.length);
        buf.writeInt(bytes.length).writeBytes(bytes);
        this.channel.writeAndFlush((Object)new DatagramPacket(buf, new InetSocketAddress(address.address(), address.port())));
    }

    @Override
    public synchronized void addListener(String subject, BiConsumer<Address, byte[]> listener, Executor executor) {
        this.listeners.computeIfAbsent(subject, s -> Maps.newConcurrentMap()).put(listener, executor);
    }

    @Override
    public synchronized void removeListener(String subject, BiConsumer<Address, byte[]> listener) {
        Map<BiConsumer<Address, byte[]>, Executor> listeners = this.listeners.get(subject);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(subject);
            }
        }
    }

    private CompletableFuture<Void> bootstrap() {
        Bootstrap serverBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext context, DatagramPacket packet) throws Exception {
                byte[] payload = new byte[((ByteBuf)packet.content()).readInt()];
                ((ByteBuf)packet.content()).readBytes(payload);
                Message message = (Message)SERIALIZER.decode(payload);
                Map listeners = (Map)NettyUnicastService.this.listeners.get(message.subject());
                if (listeners != null) {
                    listeners.forEach((consumer, executor) -> executor.execute(() -> consumer.accept(message.source(), message.payload())));
                }
            }
        })).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new DefaultMaxBytesRecvByteBufAllocator())).option(ChannelOption.SO_BROADCAST, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.address.address(), this.address.port())).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (f.isSuccess()) {
                this.channel = (DatagramChannel)f.channel();
                future.complete(null);
            } else {
                future.completeExceptionally(f.cause());
            }
        }));
        return future;
    }

    public CompletableFuture<UnicastService> start() {
        this.group = new NioEventLoopGroup(0, Threads.namedThreads((String)"netty-unicast-event-nio-client-%d", (Logger)this.log));
        return ((CompletableFuture)this.bootstrap().thenRun(() -> this.started.set(true))).thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.channel != null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.channel.close().addListener(f -> {
                this.started.set(false);
                this.group.shutdownGracefully();
                future.complete(null);
            });
            return future;
        }
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }

    static class Message {
        private final Address source;
        private final String subject;
        private final byte[] payload;

        Message() {
            this(null, null, null);
        }

        Message(Address source, String subject, byte[] payload) {
            this.source = source;
            this.subject = subject;
            this.payload = payload;
        }

        Address source() {
            return this.source;
        }

        String subject() {
            return this.subject;
        }

        byte[] payload() {
            return this.payload;
        }
    }

    public static class Builder
    implements UnicastService.Builder {
        private Address address;

        public Builder withAddress(Address address) {
            this.address = (Address)Preconditions.checkNotNull((Object)address);
            return this;
        }

        public ManagedUnicastService build() {
            return new NettyUnicastService(this.address);
        }
    }
}

