/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import com.google.common.base.Preconditions;
import io.atomix.cluster.discovery.MulticastDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import java.time.Duration;

public class MulticastDiscoveryConfig
extends NodeDiscoveryConfig {
    private static final int DEFAULT_BROADCAST_INTERVAL = 1000;
    private static final int DEFAULT_FAILURE_TIMEOUT = 10000;
    private static final int DEFAULT_PHI_FAILURE_THRESHOLD = 10;
    private Duration broadcastInterval = Duration.ofMillis(1000L);
    private int failureThreshold = 10;
    private Duration failureTimeout = Duration.ofMillis(10000L);

    public NodeDiscoveryProvider.Type getType() {
        return MulticastDiscoveryProvider.TYPE;
    }

    public Duration getBroadcastInterval() {
        return this.broadcastInterval;
    }

    public MulticastDiscoveryConfig setBroadcastInterval(Duration broadcastInterval) {
        this.broadcastInterval = (Duration)Preconditions.checkNotNull((Object)broadcastInterval);
        return this;
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public MulticastDiscoveryConfig setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public MulticastDiscoveryConfig setFailureTimeout(Duration failureTimeout) {
        this.failureTimeout = (Duration)Preconditions.checkNotNull((Object)failureTimeout);
        return this;
    }
}

