/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.Preconditions;
import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.utils.Builder;
import io.atomix.utils.net.Address;
import java.time.Duration;
import java.util.Properties;

public class AtomixClusterBuilder
implements Builder<AtomixCluster> {
    protected final ClusterConfig config;

    protected AtomixClusterBuilder() {
        this(new ClusterConfig());
    }

    protected AtomixClusterBuilder(ClusterConfig config) {
        this.config = (ClusterConfig)Preconditions.checkNotNull((Object)config);
    }

    public AtomixClusterBuilder withClusterId(String clusterId) {
        this.config.setClusterId(clusterId);
        return this;
    }

    public AtomixClusterBuilder withMemberId(String localMemberId) {
        this.config.getNodeConfig().setId(localMemberId);
        return this;
    }

    public AtomixClusterBuilder withMemberId(MemberId localMemberId) {
        this.config.getNodeConfig().setId(localMemberId);
        return this;
    }

    public AtomixClusterBuilder withAddress(String address) {
        return this.withAddress(Address.from((String)address));
    }

    public AtomixClusterBuilder withAddress(String host, int port) {
        return this.withAddress(Address.from((String)host, (int)port));
    }

    public AtomixClusterBuilder withAddress(int port) {
        return this.withAddress(Address.from((int)port));
    }

    public AtomixClusterBuilder withAddress(Address address) {
        this.config.getNodeConfig().setAddress(address);
        return this;
    }

    public AtomixClusterBuilder withZone(String zone) {
        this.config.getNodeConfig().setZone(zone);
        return this;
    }

    public AtomixClusterBuilder withRack(String rack) {
        this.config.getNodeConfig().setRack(rack);
        return this;
    }

    public AtomixClusterBuilder withHost(String host) {
        this.config.getNodeConfig().setHost(host);
        return this;
    }

    public AtomixClusterBuilder withProperties(Properties properties) {
        this.config.getNodeConfig().setProperties(properties);
        return this;
    }

    public AtomixClusterBuilder withProperty(String key, String value) {
        this.config.getNodeConfig().setProperty(key, value);
        return this;
    }

    public AtomixClusterBuilder withMulticastEnabled() {
        return this.withMulticastEnabled(true);
    }

    public AtomixClusterBuilder withMulticastEnabled(boolean multicastEnabled) {
        this.config.getMulticastConfig().setEnabled(multicastEnabled);
        return this;
    }

    public AtomixClusterBuilder withMulticastAddress(Address address) {
        this.config.getMulticastConfig().setGroup(address.address());
        this.config.getMulticastConfig().setPort(address.port());
        return this;
    }

    public AtomixClusterBuilder setBroadcastInterval(Duration interval) {
        this.config.getMembershipConfig().setBroadcastInterval(interval);
        return this;
    }

    public AtomixClusterBuilder setReachabilityThreshold(int threshold) {
        this.config.getMembershipConfig().setReachabilityThreshold(threshold);
        return this;
    }

    public AtomixClusterBuilder withReachabilityTimeout(Duration timeout) {
        this.config.getMembershipConfig().setReachabilityTimeout(timeout);
        return this;
    }

    public AtomixClusterBuilder withMembershipProvider(NodeDiscoveryProvider locationProvider) {
        this.config.setDiscoveryConfig((NodeDiscoveryConfig)locationProvider.config());
        return this;
    }

    public AtomixCluster build() {
        return new AtomixCluster(this.config, null);
    }
}

