/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.InternalMessage;
import io.atomix.cluster.messaging.impl.InternalReply;
import io.atomix.cluster.messaging.impl.InternalRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEncoder
extends MessageToByteEncoder<Object> {
    private static final int VERSION = 1;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Address address;
    private final int preamble;
    private boolean addressWritten;

    public MessageEncoder(Address address, int preamble) {
        this.address = address;
        this.preamble = preamble;
    }

    protected void encode(ChannelHandlerContext context, Object rawMessage, ByteBuf out) throws Exception {
        if (rawMessage instanceof InternalRequest) {
            this.encodeRequest((InternalRequest)rawMessage, out);
        } else if (rawMessage instanceof InternalReply) {
            this.encodeReply((InternalReply)rawMessage, out);
        }
    }

    private void encodeMessage(InternalMessage message, ByteBuf out) {
        if (!this.addressWritten) {
            out.writeShort(1);
            InetAddress senderIp = this.address.address();
            byte[] senderIpBytes = senderIp.getAddress();
            out.writeByte(senderIpBytes.length);
            out.writeBytes(senderIpBytes);
            out.writeInt(this.address.port());
            this.addressWritten = true;
        }
        out.writeByte(message.type().id());
        out.writeInt(this.preamble);
        out.writeLong(message.id());
        byte[] payload = message.payload();
        out.writeInt(payload.length);
        out.writeBytes(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeRequest(InternalRequest request, ByteBuf out) {
        this.encodeMessage(request, out);
        ByteBuf buf = out.alloc().buffer(ByteBufUtil.utf8MaxBytes((CharSequence)request.subject()));
        try {
            int length = ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)request.subject());
            out.writeShort(length);
            out.writeBytes(buf);
        }
        finally {
            buf.release();
        }
    }

    private void encodeReply(InternalReply reply, ByteBuf out) {
        this.encodeMessage(reply, out);
        out.writeByte(reply.status().id());
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        try {
            if (cause instanceof IOException) {
                this.log.debug("IOException inside channel handling pipeline.", cause);
            } else {
                this.log.error("non-IOException inside channel handling pipeline.", cause);
            }
        }
        finally {
            context.close();
        }
    }

    public final boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof InternalMessage;
    }
}

