/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.utils.AbstractIdentifier;
import java.util.Objects;
import java.util.UUID;

public final class MemberId
extends AbstractIdentifier<String>
implements Comparable<MemberId> {
    private final Type type;

    public static MemberId anonymous() {
        return new MemberId(UUID.randomUUID().toString(), Type.ANONYMOUS);
    }

    public static MemberId from(String id) {
        return new MemberId(id, Type.IDENTIFIED);
    }

    private MemberId() {
        this("", Type.ANONYMOUS);
    }

    public MemberId(String id, Type type) {
        super((Comparable)((Object)id));
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id(), this.type()});
    }

    public boolean equals(Object object) {
        if (object instanceof MemberId) {
            MemberId memberId = (MemberId)object;
            return ((String)((Object)memberId.id())).equals(this.id()) && memberId.type() == this.type();
        }
        return false;
    }

    @Override
    public int compareTo(MemberId that) {
        return ((String)((Object)this.identifier)).compareTo((String)((Object)that.identifier));
    }

    public static enum Type {
        IDENTIFIED,
        ANONYMOUS;

    }
}

