/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberConfig;
import io.atomix.cluster.MemberId;
import io.atomix.utils.config.Configured;
import io.atomix.utils.net.Address;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Member
implements Configured<MemberConfig> {
    private final MemberId id;
    private final Address address;
    private final String zone;
    private final String rack;
    private final String host;
    private final Map<String, String> metadata;

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(String memberId) {
        return Member.builder(MemberId.from(memberId));
    }

    public static Builder builder(MemberId memberId) {
        return Member.builder().withId(memberId);
    }

    public static Member member(String address) {
        return Member.member(Address.from((String)address));
    }

    public static Member member(String name, String address) {
        return Member.member(MemberId.from(name), Address.from((String)address));
    }

    public static Member member(Address address) {
        return Member.builder().withAddress(address).build();
    }

    public static Member member(MemberId memberId, Address address) {
        return Member.builder(memberId).withAddress(address).build();
    }

    public Member(MemberConfig config) {
        this.id = config.getId();
        this.address = (Address)Preconditions.checkNotNull((Object)config.getAddress(), (Object)"address cannot be null");
        this.zone = config.getZone();
        this.rack = config.getRack();
        this.host = config.getHost();
        this.metadata = new HashMap<String, String>(config.getMetadata());
    }

    protected Member(MemberId id, Address address, String zone, String rack, String host, Map<String, String> metadata) {
        this.id = (MemberId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.address = (Address)Preconditions.checkNotNull((Object)address, (Object)"address cannot be null");
        this.zone = zone;
        this.rack = rack;
        this.host = host;
        this.metadata = new HashMap<String, String>(metadata);
    }

    public MemberId id() {
        return this.id;
    }

    public Address address() {
        return this.address;
    }

    public State getState() {
        throw new UnsupportedOperationException();
    }

    public String zone() {
        return this.zone;
    }

    public String rack() {
        return this.rack;
    }

    public String host() {
        return this.host;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public MemberConfig config() {
        return new MemberConfig().setId(this.id).setAddress(this.address).setZone(this.zone).setRack(this.rack).setHost(this.host).setMetadata(this.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        return object instanceof Member && ((Member)object).id.equals(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("address", (Object)this.address).add("zone", (Object)this.zone).add("rack", (Object)this.rack).add("host", (Object)this.host).add("metadata", this.metadata).omitNullValues().toString();
    }

    public static class Builder
    implements io.atomix.utils.Builder<Member> {
        protected final MemberConfig config = new MemberConfig();

        protected Builder(MemberId id) {
            if (id != null) {
                this.config.setId(id);
            }
        }

        public Builder withId(String id) {
            return this.withId(MemberId.from(id));
        }

        public Builder withId(MemberId id) {
            this.config.setId(id);
            return this;
        }

        public Builder withAddress(String address) {
            return this.withAddress(Address.from((String)address));
        }

        public Builder withAddress(String host, int port) {
            return this.withAddress(Address.from((String)host, (int)port));
        }

        public Builder withAddress(int port) {
            return this.withAddress(Address.from((int)port));
        }

        public Builder withAddress(Address address) {
            this.config.setAddress(address);
            return this;
        }

        public Builder withZone(String zone) {
            this.config.setZone(zone);
            return this;
        }

        public Builder withRack(String rack) {
            this.config.setRack(rack);
            return this;
        }

        public Builder withHost(String host) {
            this.config.setHost(host);
            return this;
        }

        public Builder withMetadata(Map<String, String> metadata) {
            this.config.setMetadata(metadata);
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.config.addMetadata(key, value);
            return this;
        }

        public Member build() {
            return new Member(this.config);
        }
    }

    public static enum State {
        ACTIVE,
        INACTIVE;

    }
}

