/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.GroupMembershipConfig;
import io.atomix.cluster.MemberConfig;
import io.atomix.utils.config.Config;
import io.atomix.utils.net.Address;
import io.atomix.utils.net.MalformedAddressException;
import java.util.ArrayList;
import java.util.List;

public class ClusterConfig
implements Config {
    private static final String DEFAULT_CLUSTER_NAME = "atomix";
    private static final String DEFAULT_MULTICAST_IP = "230.0.0.1";
    private static final int DEFAULT_MULTICAST_PORT = 54321;
    private String name = "atomix";
    private String localMemberId;
    private MemberConfig localMember;
    private List<MemberConfig> members = new ArrayList<MemberConfig>();
    private boolean multicastEnabled = false;
    private Address multicastAddress;
    private GroupMembershipConfig membershipConfig = new GroupMembershipConfig();

    public ClusterConfig() {
        try {
            this.multicastAddress = Address.from((String)DEFAULT_MULTICAST_IP, (int)54321);
        }
        catch (MalformedAddressException e) {
            this.multicastAddress = Address.from((int)54321);
        }
    }

    public String getName() {
        return this.name;
    }

    public ClusterConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getLocalMemberId() {
        return this.localMemberId;
    }

    public ClusterConfig setLocalMemberId(String localMemberId) {
        this.localMemberId = localMemberId;
        return this;
    }

    public MemberConfig getLocalMember() {
        MemberConfig member = this.localMember;
        if (member == null && this.localMemberId != null) {
            member = this.members.stream().filter(m -> ((String)((Object)m.getId().id())).equals(this.localMemberId)).findFirst().orElse(null);
        }
        return member;
    }

    public ClusterConfig setLocalMember(MemberConfig localMember) {
        this.localMember = localMember;
        return this;
    }

    public List<MemberConfig> getMembers() {
        return this.members;
    }

    public ClusterConfig setMembers(List<MemberConfig> members) {
        this.members = members;
        return this;
    }

    public ClusterConfig addMember(MemberConfig member) {
        this.members.add(member);
        return this;
    }

    public boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    public ClusterConfig setMulticastEnabled(boolean multicastEnabled) {
        this.multicastEnabled = multicastEnabled;
        return this;
    }

    public Address getMulticastAddress() {
        return this.multicastAddress;
    }

    public ClusterConfig setMulticastAddress(Address multicastAddress) {
        this.multicastAddress = multicastAddress;
        return this;
    }

    public GroupMembershipConfig getMembershipConfig() {
        return this.membershipConfig;
    }

    public ClusterConfig setMembershipConfig(GroupMembershipConfig membershipConfig) {
        this.membershipConfig = membershipConfig;
        return this;
    }
}

