/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class ClusterMetadata {
    private final Collection<Node> bootstrapNodes;

    public static Builder builder() {
        return new Builder();
    }

    public ClusterMetadata(Collection<Node> bootstrapNodes) {
        this.bootstrapNodes = bootstrapNodes.stream().filter(node -> node.type() == Node.Type.DATA).collect(Collectors.toSet());
    }

    public Collection<Node> bootstrapNodes() {
        return this.bootstrapNodes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bootstrapNodes", this.bootstrapNodes).toString();
    }

    public static class Builder
    implements io.atomix.utils.Builder<ClusterMetadata> {
        protected Collection<Node> bootstrapNodes;

        public Builder withBootstrapNodes(Node ... bootstrapNodes) {
            return this.withBootstrapNodes(Arrays.asList((Object[])Preconditions.checkNotNull((Object)bootstrapNodes)));
        }

        public Builder withBootstrapNodes(Collection<Node> bootstrapNodes) {
            this.bootstrapNodes = (Collection)Preconditions.checkNotNull(bootstrapNodes, (Object)"bootstrapNodes cannot be null");
            return this;
        }

        public ClusterMetadata build() {
            return new ClusterMetadata(this.bootstrapNodes);
        }
    }
}

