/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import io.atomix.cluster.NodeId;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.serializers.DefaultSerializers;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ClusterMessagingService {
    default public <M> void broadcast(String subject, M message) {
        this.broadcast(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M> void broadcast(String var1, M var2, Function<M, byte[]> var3);

    default public <M> void broadcastIncludeSelf(String subject, M message) {
        this.broadcastIncludeSelf(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M> void broadcastIncludeSelf(String var1, M var2, Function<M, byte[]> var3);

    default public <M> CompletableFuture<Void> unicast(String subject, M message, NodeId toNodeId) {
        return this.unicast(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), toNodeId);
    }

    public <M> CompletableFuture<Void> unicast(String var1, M var2, Function<M, byte[]> var3, NodeId var4);

    default public <M> void multicast(String subject, M message, Set<NodeId> nodeIds) {
        this.multicast(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), nodeIds);
    }

    public <M> void multicast(String var1, M var2, Function<M, byte[]> var3, Set<NodeId> var4);

    default public <M, R> CompletableFuture<R> send(String subject, M message, NodeId toNodeId) {
        return this.send(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), toNodeId);
    }

    public <M, R> CompletableFuture<R> send(String var1, M var2, Function<M, byte[]> var3, Function<byte[], R> var4, NodeId var5);

    default public <M, R> CompletableFuture<Void> subscribe(String subject, Function<M, R> handler, Executor executor) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), executor);
    }

    public <M, R> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, Function<M, R> var3, Function<R, byte[]> var4, Executor var5);

    default public <M, R> CompletableFuture<Void> subscribe(String subject, Function<M, CompletableFuture<R>> handler) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M, R> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, Function<M, CompletableFuture<R>> var3, Function<R, byte[]> var4);

    default public <M> CompletableFuture<Void> subscribe(String subject, Consumer<M> handler, Executor executor) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, executor);
    }

    public <M> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, Consumer<M> var3, Executor var4);

    public void unsubscribe(String var1);
}

