/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.messaging.Endpoint;
import java.util.Objects;

public class Node {
    private final NodeId id;
    private final Type type;
    private final Endpoint endpoint;

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(String nodeId) {
        return Node.builder(NodeId.from(nodeId));
    }

    public static Builder builder(NodeId nodeId) {
        return new Builder((NodeId)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId cannot be null"));
    }

    public static Node data(NodeId nodeId, Endpoint endpoint) {
        return Node.builder(nodeId).withType(Type.DATA).withEndpoint(endpoint).build();
    }

    public static Node client(NodeId nodeId, Endpoint endpoint) {
        return Node.builder(nodeId).withType(Type.CLIENT).withEndpoint(endpoint).build();
    }

    protected Node(NodeId id, Type type, Endpoint endpoint) {
        this.id = (NodeId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
        this.endpoint = (Endpoint)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint cannot be null");
    }

    public NodeId id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public State getState() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        return object instanceof Node && ((Node)object).id.equals(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("endpoint", (Object)this.endpoint).toString();
    }

    public static class Builder
    implements io.atomix.utils.Builder<Node> {
        protected NodeId id;
        protected Type type;
        protected Endpoint endpoint;

        protected Builder(NodeId id) {
            this.id = id;
        }

        public Builder withId(NodeId id) {
            this.id = (NodeId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
            return this;
        }

        public Builder withType(Type type) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder withEndpoint(Endpoint endpoint) {
            this.endpoint = (Endpoint)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint cannot be null");
            return this;
        }

        public Node build() {
            if (this.id == null) {
                this.id = NodeId.from(this.endpoint.host().getHostName());
            }
            return new Node(this.id, this.type, this.endpoint);
        }
    }

    public static enum State {
        ACTIVE,
        INACTIVE;

    }

    public static enum Type {
        DATA,
        CLIENT;

    }
}

