/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.agent;

import ch.qos.logback.classic.Level;
import com.google.common.collect.Lists;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.MulticastDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixConfig;
import io.atomix.rest.ManagedRestService;
import io.atomix.rest.RestService;
import io.atomix.utils.net.Address;
import io.atomix.utils.net.MalformedAddressException;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixAgent {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Namespace namespace = AtomixAgent.parseArgs(args);
        Logger logger = AtomixAgent.createLogger(namespace);
        Atomix atomix = AtomixAgent.buildAtomix(namespace);
        atomix.start().join();
        logger.info("Atomix listening at {}", (Object)atomix.getMembershipService().getLocalMember().address());
        ManagedRestService rest = AtomixAgent.buildRestService(atomix, namespace);
        rest.start().join();
        logger.warn("The Atomix HTTP API is BETA and is intended for development and debugging purposes only!");
        logger.info("HTTP server listening at {}", (Object)rest.address());
        Class<Atomix> clazz = Atomix.class;
        synchronized (Atomix.class) {
            while (atomix.isRunning()) {
                Atomix.class.wait();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static Namespace parseArgs(String[] args) {
        ArgumentParser parser = AtomixAgent.createParser();
        Namespace namespace = null;
        try {
            namespace = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        return namespace;
    }

    private static ArgumentParser createParser() {
        ArgumentType nodeArgumentType = (argumentParser, argument, value) -> new NodeConfig().setId((NodeId)AtomixAgent.parseMemberId(value)).setAddress(AtomixAgent.parseAddress(value));
        ArgumentType addressArgumentType = (argumentParser, argument, value) -> Address.from((String)value);
        List<String> logLevels = Arrays.asList(Level.ALL.toString(), Level.OFF.toString(), Level.ERROR.toString(), Level.WARN.toString(), Level.INFO.toString(), Level.DEBUG.toString(), Level.TRACE.toString());
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"AtomixServer").defaultHelp(true).description("Atomix server");
        parser.addArgument(new String[]{"--member", "-m"}).type(String.class).nargs("?").required(false).help("The local member identifier, used in intra-cluster communication.");
        parser.addArgument(new String[]{"--address", "-a"}).type(addressArgumentType).metavar(new String[]{"HOST:PORT"}).nargs("?").required(false).help("The address for the local member. If no address is specified, the first public interface will be used.");
        parser.addArgument(new String[]{"--host"}).type(String.class).nargs("?").required(false).help("The host on which this member runs, used for host-aware partition management.");
        parser.addArgument(new String[]{"--rack"}).type(String.class).nargs("?").required(false).help("The rack on which this member runs, used for rack-aware partition management.");
        parser.addArgument(new String[]{"--zone"}).type(String.class).nargs("?").required(false).help("The zone in which this member runs, used for zone-aware partition management.");
        parser.addArgument(new String[]{"--config", "-c"}).metavar(new String[]{"CONF|JSON|PROPERTIES"}).type(File.class).nargs("*").required(false).setDefault((Object)(System.getProperty("atomix.config.files") != null ? Lists.newArrayList((Object[])System.getProperty("atomix.config.files").split(",")) : Lists.newArrayList())).help("The Atomix configuration. Can be specified as a file path or JSON/YAML string.");
        parser.addArgument(new String[]{"--ignore-resources"}).action((ArgumentAction)new StoreTrueArgumentAction()).setDefault((Object)false).help("Ignores classpath resources when loading configuration files. Only valid when configuration file(s) are provided.");
        parser.addArgument(new String[]{"--log-config"}).metavar(new String[]{"FILE"}).type(String.class).nargs("?").setDefault((Object)System.getProperty("atomix.logback")).help("The path to an optional logback configuration file outside the classpath.");
        parser.addArgument(new String[]{"--log-dir"}).metavar(new String[]{"FILE"}).type(String.class).nargs("?").setDefault((Object)System.getProperty("atomix.log.directory", new File(System.getProperty("user.dir"), "logs").getPath())).help("The path to the Atomix log directory. This option is only valid for logback configurations that employ the atomix.log.directory property.");
        parser.addArgument(new String[]{"--log-level"}).metavar(new String[]{"LEVEL"}).type(String.class).choices(logLevels).nargs("?").setDefault((Object)System.getProperty("atomix.log.level", Level.DEBUG.toString())).help("The globally filtered log level for all Atomix logs. This option is only valid for logback configurations that employ the atomix.log.level property.");
        parser.addArgument(new String[]{"--file-log-level"}).metavar(new String[]{"LEVEL"}).type(String.class).choices(logLevels).nargs("?").setDefault((Object)System.getProperty("atomix.log.file.level", Level.DEBUG.toString())).help("The file log level. This option is only valid for logback configurations that employ the atomix.log.file.level property.");
        parser.addArgument(new String[]{"--console-log-level"}).metavar(new String[]{"LEVEL"}).type(String.class).choices(logLevels).nargs("?").setDefault((Object)System.getProperty("atomix.log.console.level", Level.INFO.toString())).help("The console log level. This option is only valid for logback configurations that employ the atomix.log.console.level property.");
        parser.addArgument(new String[]{"--data-dir"}).metavar(new String[]{"FILE"}).type(String.class).nargs("?").setDefault((Object)System.getProperty("atomix.data", ".data")).help("The default Atomix data directory. Defaults to .data");
        parser.addArgument(new String[]{"--bootstrap", "-b"}).nargs("*").type(nodeArgumentType).metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The set of static members to join. When provided, bootstrap node discovery will be used.");
        parser.addArgument(new String[]{"--multicast"}).action((ArgumentAction)new StoreTrueArgumentAction()).setDefault((Object)false).help("Enables multicast discovery. Note that the network must support multicast for this feature to work.");
        parser.addArgument(new String[]{"--multicast-group"}).type(String.class).metavar(new String[]{"IP"}).help("Sets the multicast group. Defaults to 230.0.0.1");
        parser.addArgument(new String[]{"--multicast-port"}).type(Integer.class).metavar(new String[]{"PORT"}).help("Sets the multicast port. Defaults to 54321");
        parser.addArgument(new String[]{"--http-host"}).type(String.class).metavar(new String[]{"HOST"}).required(false).setDefault((Object)"0.0.0.0").help("Sets the host to which to bind the HTTP server. Defaults to 0.0.0.0 (all interfaces)");
        parser.addArgument(new String[]{"--http-port", "-p"}).type(Integer.class).metavar(new String[]{"PORT"}).required(false).setDefault((Object)5678).help("Sets the port on which to run the HTTP server. Defaults to 5678");
        return parser;
    }

    private static Logger createLogger(Namespace namespace) {
        String logConfig = namespace.getString("log_config");
        if (logConfig != null) {
            System.setProperty("logback.configurationFile", logConfig);
        }
        System.setProperty("atomix.log.directory", namespace.getString("log_dir"));
        System.setProperty("atomix.log.level", namespace.getString("log_level"));
        System.setProperty("atomix.log.console.level", namespace.getString("console_log_level"));
        System.setProperty("atomix.log.file.level", namespace.getString("file_log_level"));
        return LoggerFactory.getLogger(AtomixAgent.class);
    }

    private static AtomixConfig createConfig(Namespace namespace) {
        AtomixConfig config;
        List configFiles = namespace.getList("config");
        String memberId = namespace.getString("member");
        Address address = (Address)namespace.get("address");
        String host = namespace.getString("host");
        String rack = namespace.getString("rack");
        String zone = namespace.getString("zone");
        List bootstrap = namespace.getList("bootstrap");
        boolean multicastEnabled = namespace.getBoolean("multicast");
        String multicastGroup = (String)namespace.get("multicast_group");
        Integer multicastPort = (Integer)namespace.get("multicast_port");
        System.setProperty("atomix.data", namespace.getString("data_dir"));
        if (configFiles != null && !configFiles.isEmpty()) {
            System.setProperty("atomix.config.resources", "");
            config = Atomix.config((List)configFiles);
        } else {
            config = Atomix.config();
        }
        if (memberId != null) {
            config.getClusterConfig().getNodeConfig().setId(memberId);
        }
        if (address != null) {
            config.getClusterConfig().getNodeConfig().setAddress(address);
        }
        if (host != null) {
            config.getClusterConfig().getNodeConfig().setHost(host);
        }
        if (rack != null) {
            config.getClusterConfig().getNodeConfig().setRack(rack);
        }
        if (zone != null) {
            config.getClusterConfig().getNodeConfig().setZone(zone);
        }
        if (bootstrap != null && !bootstrap.isEmpty()) {
            config.getClusterConfig().setDiscoveryConfig((NodeDiscoveryConfig)new BootstrapDiscoveryConfig().setNodes((Collection)bootstrap));
        }
        if (multicastEnabled) {
            config.getClusterConfig().getMulticastConfig().setEnabled(true);
            if (multicastGroup != null) {
                config.getClusterConfig().getMulticastConfig().setGroup(multicastGroup);
            }
            if (multicastPort != null) {
                config.getClusterConfig().getMulticastConfig().setPort(multicastPort.intValue());
            }
            if (bootstrap == null || bootstrap.isEmpty()) {
                config.getClusterConfig().setDiscoveryConfig((NodeDiscoveryConfig)new MulticastDiscoveryConfig());
            }
        }
        return config;
    }

    private static Atomix buildAtomix(Namespace namespace) {
        return Atomix.builder((AtomixConfig)AtomixAgent.createConfig(namespace)).withShutdownHookEnabled().build();
    }

    private static ManagedRestService buildRestService(Atomix atomix, Namespace namespace) {
        String httpHost = namespace.getString("http_host");
        Integer httpPort = namespace.getInt("http_port");
        return (ManagedRestService)RestService.builder().withAtomix(atomix).withAddress(Address.from((String)httpHost, (int)httpPort)).build();
    }

    static MemberId parseMemberId(String address) {
        int endIndex = address.indexOf(64);
        if (endIndex > 0) {
            return MemberId.from((String)address.substring(0, endIndex));
        }
        return null;
    }

    static Address parseAddress(String address) {
        int startIndex = address.indexOf(64);
        if (startIndex == -1) {
            try {
                return Address.from((String)address);
            }
            catch (MalformedAddressException e) {
                return Address.local();
            }
        }
        return Address.from((String)address.substring(startIndex + 1));
    }
}

