/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.agent;

import io.atomix.cluster.Node;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixConfig;
import io.atomix.core.config.impl.DefaultConfigService;
import io.atomix.rest.ManagedRestService;
import io.atomix.rest.RestService;
import io.atomix.utils.net.Address;
import io.atomix.utils.net.MalformedAddressException;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Atomix.Builder builder;
        Function<Node.Type, ArgumentType> nodeArgumentType = type -> (argumentParser, argument, value) -> new NodeConfig().setId(AtomixAgent.parseNodeId(value)).setType(type).setAddress(AtomixAgent.parseAddress(value));
        ArgumentType typeArgumentType = (argumentParser, argument, value) -> Node.Type.valueOf((String)value.toUpperCase());
        ArgumentType addressArgumentType = (argumentParser, argument, value) -> Address.from((String)value);
        ArgumentType fileArgumentType = (argumentParser, argument, value) -> new File(value);
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"AtomixServer").defaultHelp(true).description("Atomix server");
        parser.addArgument(new String[]{"node"}).type(nodeArgumentType.apply(Node.Type.CORE)).nargs("?").metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The node info for the local node. This should be in the format [NAME@]HOST[:PORT]. If no name is provided, the node name will default to the host. If no port is provided, the port will default to 5679.");
        parser.addArgument(new String[]{"--type", "-t"}).type(typeArgumentType).metavar(new String[]{"TYPE"}).choices((Object[])new Node.Type[]{Node.Type.CORE, Node.Type.DATA, Node.Type.CLIENT}).setDefault((Object)Node.Type.CORE).help("Indicates the local node type.");
        parser.addArgument(new String[]{"--config", "-c"}).metavar(new String[]{"FILE|JSON|YAML"}).required(false).help("The Atomix configuration. Can be specified as a file path or JSON/YAML string.");
        parser.addArgument(new String[]{"--core-nodes", "-n"}).nargs("*").type(nodeArgumentType.apply(Node.Type.CORE)).metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The set of core nodes, if any. When bootstrapping a new cluster, if the local node is a core node then it should be present in the core configuration as well.");
        parser.addArgument(new String[]{"--bootstrap-nodes", "-b"}).nargs("*").type(nodeArgumentType.apply(Node.Type.DATA)).metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The set of bootstrap nodes. If core nodes are provided, the cluster will be bootstrapped from the core nodes. For clusters without core nodes, at least one bootstrap node must be provided unless using multicast discovery or bootstrapping a new cluster.");
        parser.addArgument(new String[]{"--multicast", "-m"}).action((ArgumentAction)new StoreTrueArgumentAction()).setDefault((Object)false).help("Enables multicast discovery. Note that the network must support multicast for this feature to work.");
        parser.addArgument(new String[]{"--multicast-address", "-a"}).type(addressArgumentType).metavar(new String[]{"HOST:PORT"}).help("Sets the multicast discovery address. Defaults to 230.0.0.1:54321");
        parser.addArgument(new String[]{"--data-dir", "-d"}).type(fileArgumentType).metavar(new String[]{"FILE"}).required(false).help("Sets the global Atomix data directory used for storing system data.");
        parser.addArgument(new String[]{"--http-port", "-p"}).type(Integer.class).metavar(new String[]{"PORT"}).required(false).setDefault((Object)5678).help("Sets the port on which to run the HTTP server. Defaults to 5678");
        Namespace namespace = null;
        try {
            namespace = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        String configString = (String)namespace.get("config");
        NodeConfig localNode = (NodeConfig)namespace.get("node");
        Node.Type localNodeType = (Node.Type)namespace.get("type");
        List coreNodes = namespace.getList("core_nodes");
        List bootstrapNodes = namespace.getList("bootstrap_nodes");
        boolean multicastEnabled = namespace.getBoolean("multicast");
        Address multicastAddress = (Address)namespace.get("multicast_address");
        File dataDir = (File)namespace.get("data_dir");
        Integer httpPort = namespace.getInt("http_port");
        if (configString != null) {
            AtomixConfig config = AtomixAgent.loadConfig(configString);
            if (localNode != null) {
                config.getClusterConfig().getNodes().stream().filter(node -> node.getId().equals((Object)localNode.getId())).findAny().ifPresent(localNodeConfig -> {
                    if (localNodeType == null) {
                        localNode.setType(localNodeConfig.getType());
                    }
                    localNode.setAddress(localNodeConfig.getAddress());
                    localNode.setZone(localNodeConfig.getZone());
                    localNode.setRack(localNodeConfig.getRack());
                    localNode.setHost(localNodeConfig.getHost());
                });
            }
            builder = Atomix.builder((AtomixConfig)config);
        } else {
            builder = Atomix.builder();
        }
        builder.withShutdownHook(true);
        if (localNode != null) {
            localNode.setType(localNodeType);
            Node node2 = new Node(localNode);
            builder.withLocalNode(node2);
            LOGGER.info("node: {}", (Object)node2);
        }
        if (coreNodes != null || bootstrapNodes != null) {
            List nodes = Stream.concat(coreNodes != null ? coreNodes.stream() : Stream.empty(), bootstrapNodes != null ? bootstrapNodes.stream() : Stream.empty()).map(node -> Node.builder((NodeId)node.getId()).withType(node.getType()).withAddress(node.getAddress()).build()).collect(Collectors.toList());
            builder.withNodes(nodes);
        }
        if (multicastEnabled) {
            builder.withMulticastEnabled();
            if (multicastAddress != null) {
                builder.withMulticastAddress(multicastAddress);
            }
        }
        if (dataDir != null) {
            builder.withDataDirectory(dataDir);
        }
        Atomix atomix = builder.build();
        atomix.start().join();
        LOGGER.info("Atomix listening at {}:{}", (Object)atomix.clusterService().getLocalNode().address().host(), (Object)atomix.clusterService().getLocalNode().address().port());
        ManagedRestService rest = (ManagedRestService)RestService.builder().withAtomix(atomix).withAddress(Address.from((String)atomix.clusterService().getLocalNode().address().host(), (int)httpPort)).build();
        rest.start().join();
        LOGGER.info("HTTP server listening at {}:{}", (Object)atomix.clusterService().getLocalNode().address().address().getHostAddress(), (Object)httpPort);
        Class<Atomix> clazz = Atomix.class;
        synchronized (Atomix.class) {
            while (atomix.isRunning()) {
                Atomix.class.wait();
            }
            // ** MonitorExit[var19_20] (shouldn't be in output)
            return;
        }
    }

    private static AtomixConfig loadConfig(String config) {
        File configFile = new File(config);
        if (configFile.exists()) {
            return (AtomixConfig)new DefaultConfigService().load(configFile, AtomixConfig.class);
        }
        return (AtomixConfig)new DefaultConfigService().load(config, AtomixConfig.class);
    }

    static NodeId parseNodeId(String address) {
        int endIndex = address.indexOf(64);
        if (endIndex > 0) {
            return NodeId.from((String)address.substring(0, endIndex));
        }
        try {
            return NodeId.from((String)Address.from((String)address).host());
        }
        catch (MalformedAddressException e) {
            return NodeId.from((String)address);
        }
    }

    static Address parseAddress(String address) {
        int startIndex = address.indexOf(64);
        if (startIndex == -1) {
            try {
                return Address.from((String)address);
            }
            catch (MalformedAddressException e) {
                return Address.from((String)"0.0.0.0");
            }
        }
        return Address.from((String)address.substring(startIndex + 1));
    }
}

