/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.util;

public final class Calculation {
    private Calculation() {
    }

    public static int binaryLogOf(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Cannot calculate binary log of non-positive value: " + value);
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int greatestPowerOfTwoIn(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Cannot calculate highest power of 2 in non-positive value: " + value);
        }
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value ^ value >> 1;
    }
}

