/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.util;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TypeResolution {
    private TypeResolution() {
    }

    public static Class<?> safelyGetClass(Object object) {
        return object == null ? Void.class : object.getClass();
    }

    public static <T> Class<T> classForQualifiedName(String qualifiedName) {
        try {
            return Class.forName(qualifiedName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get/find Class with qualified name: " + qualifiedName, e);
        }
    }

    public static boolean isGenericClass(Class<?> clazz) {
        return TypeResolution.streamAllTypeParameters(clazz).findAny().isPresent();
    }

    public static boolean isDataStructure(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    public static Set<Type> getAllTypeParameters(Class<?> clazz) {
        return TypeResolution.streamAllTypeParameters(clazz).collect(Collectors.toSet());
    }

    private static Stream<TypeVariable<?>> streamAllTypeParameters(Class<?> clazz) {
        return TypeResolution.withSuperClasses(clazz).stream().map(Class::getTypeParameters).flatMap(Arrays::stream);
    }

    private static List<Class<?>> withSuperClasses(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        classes.add(clazz);
        while ((clazz = clazz.getSuperclass()) != null) {
            classes.add(clazz);
        }
        return classes;
    }
}

