/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.atleon.rabbitmq.ExchangeDeclaration;
import io.atleon.rabbitmq.QueueBinding;
import io.atleon.rabbitmq.QueueDeclaration;
import io.atleon.rabbitmq.RoutingInitializer;
import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class RabbitMQRoutingInitialization
implements ApplicationListener<ApplicationContextEvent>,
Ordered {
    private final RoutingInitializer routingInitializer;

    public RabbitMQRoutingInitialization(RoutingInitializer routingInitializer) {
        this.routingInitializer = routingInitializer;
    }

    public static RabbitMQRoutingInitialization using(ConnectionFactory connectionFactory) {
        return new RabbitMQRoutingInitialization(RoutingInitializer.using((ConnectionFactory)connectionFactory));
    }

    public static RabbitMQRoutingInitialization using(Connection connection) {
        return new RabbitMQRoutingInitialization(RoutingInitializer.using((Connection)connection));
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.routingInitializer.run();
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public RabbitMQRoutingInitialization addExchangeDeclaration(ExchangeDeclaration exchangeDeclaration) {
        return new RabbitMQRoutingInitialization(this.routingInitializer.addExchangeDeclaration(exchangeDeclaration));
    }

    public RabbitMQRoutingInitialization exchangeDeclarations(List<ExchangeDeclaration> exchangeDeclarations) {
        return new RabbitMQRoutingInitialization(this.routingInitializer.exchangeDeclarations(exchangeDeclarations));
    }

    public RabbitMQRoutingInitialization addQueueDeclaration(QueueDeclaration queueDeclaration) {
        return new RabbitMQRoutingInitialization(this.routingInitializer.addQueueDeclaration(queueDeclaration));
    }

    public RabbitMQRoutingInitialization queueDeclarations(List<QueueDeclaration> queueDeclarations) {
        return new RabbitMQRoutingInitialization(this.routingInitializer.queueDeclarations(queueDeclarations));
    }

    public RabbitMQRoutingInitialization addQueueBinding(QueueBinding queueBinding) {
        return new RabbitMQRoutingInitialization(this.routingInitializer.addQueueBinding(queueBinding));
    }

    public RabbitMQRoutingInitialization queueBindings(List<QueueBinding> queueBindings) {
        return new RabbitMQRoutingInitialization(this.routingInitializer.queueBindings(queueBindings));
    }
}

