/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.schema;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public final class KeyableSchema<S> {
    private final Serializable key;
    private final S schema;

    private KeyableSchema(Serializable key, S schema) {
        this.key = key;
        this.schema = Objects.requireNonNull(schema);
    }

    public static <S> KeyableSchema<S> keyed(Serializable key, S schema) {
        return new KeyableSchema<S>(Objects.requireNonNull(key), schema);
    }

    public static <S> KeyableSchema<S> unkeyed(S schema) {
        return new KeyableSchema<S>(null, schema);
    }

    public Optional<Serializable> key() {
        return Optional.ofNullable(this.key);
    }

    public S schema() {
        return this.schema;
    }
}

