/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.function.Function;

@FunctionalInterface
public interface Tagger<T> {
    public static <T> Tagger<T> composed(Iterable<Tag> base, Function<? super T, ? extends Iterable<Tag>> extractor) {
        return new Composed(base, extractor);
    }

    default public Iterable<Tag> base() {
        return Tags.empty();
    }

    public Iterable<Tag> extract(T var1);

    public static class Composed<T>
    implements Tagger<T> {
        private final Iterable<Tag> base;
        private final Function<? super T, ? extends Iterable<Tag>> extractor;

        private Composed(Iterable<Tag> base, Function<? super T, ? extends Iterable<Tag>> extractor) {
            this.base = base;
            this.extractor = extractor;
        }

        @Override
        public Iterable<Tag> base() {
            return this.base;
        }

        @Override
        public Iterable<Tag> extract(T t) {
            return this.extractor.apply(t);
        }
    }
}

