/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.micrometer.MeterKey;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class MeterFacade<K> {
    private final MeterRegistry registry;
    private final Function<? super K, MeterKey> keyToMeterKey;
    private final Map<K, Counter> counters = new ConcurrentHashMap<K, Counter>();
    private final Map<K, Timer> timers = new ConcurrentHashMap<K, Timer>();

    private MeterFacade(MeterRegistry registry, Function<? super K, MeterKey> keyToMeterKey) {
        this.registry = registry;
        this.keyToMeterKey = keyToMeterKey;
    }

    public static <K> MeterFacade<K> create(MeterRegistry registry, Function<? super K, MeterKey> keyToMeterKey) {
        return new MeterFacade<K>(registry, keyToMeterKey);
    }

    public Counter counter(K key) {
        return this.counters.computeIfAbsent(key, this::newCounter);
    }

    public Timer timer(K key) {
        return this.timers.computeIfAbsent(key, this::newTimer);
    }

    public void clear() {
        this.counters.clear();
        this.timers.clear();
    }

    private Counter newCounter(K key) {
        MeterKey meterKey = this.keyToMeterKey.apply(key);
        return this.registry.counter(meterKey.getName(), meterKey.getTags());
    }

    private Timer newTimer(K key) {
        MeterKey meterKey = this.keyToMeterKey.apply(key);
        return this.registry.timer(meterKey.getName(), meterKey.getTags());
    }
}

