/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.micrometer.MeterKey;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class AuditedMetricRegistry<A, M, R> {
    private final Map<MeterKey, MeterKey> internedKeys = new ConcurrentHashMap<MeterKey, MeterKey>();
    private final Map<MeterKey, AuditedMetric<A, M>> auditedMetricsByKey = new ConcurrentHashMap<MeterKey, AuditedMetric<A, M>>();
    private final BiFunction<A, M, R> evaluator;
    private final R absentEvaluation;

    public AuditedMetricRegistry(BiFunction<A, M, R> evaluator, R absentEvaluation) {
        this.evaluator = evaluator;
        this.absentEvaluation = absentEvaluation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeterKey register(MeterKey key, A auditor, M metric) {
        MeterKey internedKey = this.internKey(key);
        AuditedMetric<A, M> auditedMetric = new AuditedMetric<A, M>(auditor, metric);
        if (!Objects.equals(this.auditedMetricsByKey.get(internedKey), auditedMetric)) {
            Map<MeterKey, AuditedMetric<A, M>> map = this.auditedMetricsByKey;
            synchronized (map) {
                this.auditedMetricsByKey.put(internedKey, auditedMetric);
            }
        }
        return internedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(MeterKey key, A auditor) {
        Map<MeterKey, AuditedMetric<A, M>> map = this.auditedMetricsByKey;
        synchronized (map) {
            if (this.isCurrentAuditor(key, auditor)) {
                this.auditedMetricsByKey.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(A auditor) {
        Map<MeterKey, AuditedMetric<A, M>> map = this.auditedMetricsByKey;
        synchronized (map) {
            this.auditedMetricsByKey.values().removeIf(auditedMetric -> auditedMetric.isAuditedBy(auditor));
        }
    }

    public R evaluate(MeterKey key) {
        return (R)Optional.ofNullable(this.auditedMetricsByKey.get(key)).map(auditedMetric -> auditedMetric.evaluate(this.evaluator)).orElse(this.absentEvaluation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeterKey internKey(MeterKey key) {
        MeterKey internedKey = this.internedKeys.get(key);
        if (internedKey == null) {
            Map<MeterKey, MeterKey> map = this.internedKeys;
            synchronized (map) {
                internedKey = this.internedKeys.computeIfAbsent(key, Function.identity());
            }
        }
        return internedKey;
    }

    private boolean isCurrentAuditor(MeterKey key, A auditor) {
        return Optional.ofNullable(this.auditedMetricsByKey.get(key)).map(auditedMetric -> auditedMetric.isAuditedBy(auditor)).orElse(false);
    }

    private static final class AuditedMetric<A, M> {
        private final A auditor;
        private final M metric;

        public AuditedMetric(A auditor, M metric) {
            this.auditor = auditor;
            this.metric = metric;
        }

        public <R> R evaluate(BiFunction<A, M, R> evaluator) {
            return evaluator.apply(this.auditor, this.metric);
        }

        public boolean isAuditedBy(A otherAuditor) {
            return Objects.equals(this.auditor, otherAuditor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditedMetric that = (AuditedMetric)o;
            return Objects.equals(this.auditor, that.auditor) && Objects.equals(this.metric, that.metric);
        }

        public int hashCode() {
            return Objects.hash(this.auditor, this.metric);
        }
    }
}

