/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MeterKey {
    private final String name;
    private final Tags tags;

    public MeterKey(String name, Map<String, String> tags) {
        this(name, tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()));
    }

    public MeterKey(String name, Iterable<Tag> tags) {
        this(name, Tags.of(tags));
    }

    public MeterKey(String name, Tags tags) {
        this.name = name;
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterKey meterKey = (MeterKey)o;
        return Objects.equals(this.name, meterKey.name) && Objects.equals(this.tags, meterKey.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }

    public String toString() {
        return "MeterKey{name='" + this.name + "', tags=" + this.tags + "}";
    }

    public String getName() {
        return this.name;
    }

    public Iterable<Tag> getTags() {
        return this.tags;
    }
}

