/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.core.AloQueueListener;
import io.atleon.micrometer.AuditedMetricRegistry;
import io.atleon.micrometer.MeterKey;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MeteringAloQueueListener<K>
implements AloQueueListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeteringAloQueueListener.class);
    private static final double ABSENT_EVALUATION = Double.NaN;
    private static final AuditedMetricRegistry<MeteringAloQueueListener<?>, Object, Double> IN_FLIGHT_GROUP_REGISTRY = new AuditedMetricRegistry<MeteringAloQueueListener, Object, Double>(MeteringAloQueueListener::evaluateInFlight, Double.NaN);
    private final MeterRegistry meterRegistry;
    private final String inFlightMetricName;
    private final Map<K, AtomicLong> inFlightsByGroupKey = new ConcurrentHashMap<K, AtomicLong>();
    private volatile boolean closed = false;

    protected MeteringAloQueueListener(String inFlightMetricName) {
        this((MeterRegistry)Metrics.globalRegistry, inFlightMetricName);
    }

    protected MeteringAloQueueListener(MeterRegistry meterRegistry, String inFlightMetricName) {
        this.meterRegistry = meterRegistry;
        this.inFlightMetricName = inFlightMetricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void created(Object group) {
        Map<K, AtomicLong> map = this.inFlightsByGroupKey;
        synchronized (map) {
            if (!this.closed) {
                this.inFlightsByGroupKey.computeIfAbsent(this.extractKey(group), this::registerNewGroup);
            }
        }
    }

    public final void enqueued(Object group, long count) {
        this.addToInFlight(this.extractKey(group), count);
    }

    public final void dequeued(Object group, long count) {
        this.addToInFlight(this.extractKey(group), -count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<K, AtomicLong> map = this.inFlightsByGroupKey;
        synchronized (map) {
            this.closed = true;
            IN_FLIGHT_GROUP_REGISTRY.unregister(this);
            this.inFlightsByGroupKey.clear();
        }
    }

    protected abstract K extractKey(Object var1);

    protected final AtomicLong registerNewGroup(K groupKey) {
        MeterKey meterKey = new MeterKey(this.inFlightMetricName, this.extractTags(groupKey));
        this.registerGauge(IN_FLIGHT_GROUP_REGISTRY.register(meterKey, this, groupKey));
        return new AtomicLong();
    }

    protected abstract Iterable<Tag> extractTags(K var1);

    private void addToInFlight(K groupKey, long count) {
        AtomicLong inFlight = this.inFlightsByGroupKey.get(groupKey);
        if (inFlight != null) {
            inFlight.addAndGet(count);
        }
    }

    private double evaluateInFlight(Object groupKey) {
        AtomicLong inFlight = this.inFlightsByGroupKey.get(groupKey);
        return inFlight == null ? Double.NaN : inFlight.doubleValue();
    }

    private void registerGauge(MeterKey meterKey) {
        try {
            Gauge.builder((String)this.inFlightMetricName, (Object)meterKey, IN_FLIGHT_GROUP_REGISTRY::evaluate).description("The number of in-flight Alo items awaiting acknowledgement execution").tags(meterKey.getTags()).register(this.meterRegistry);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to register Gauge with key={}", (Object)meterKey, (Object)e);
        }
    }
}

