/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.core.AbstractDecoratingAlo;
import io.atleon.core.Alo;
import io.atleon.micrometer.AloMeters;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;

public class MeteringAlo<T>
extends AbstractDecoratingAlo<T> {
    protected final AloMeters meters;
    protected final long startedAtNano;

    private MeteringAlo(Alo<T> delegate, AloMeters meters, long startedAtNano) {
        super(delegate);
        this.meters = meters;
        this.startedAtNano = startedAtNano;
    }

    public static <T> MeteringAlo<T> start(Alo<T> delegate, AloMeters meters) {
        return new MeteringAlo<T>(delegate, meters, System.nanoTime());
    }

    public <R> Alo<R> map(Function<? super T, ? extends R> mapper) {
        return new MeteringAlo<T>(this.delegate.map(mapper), this.meters, this.startedAtNano);
    }

    public Runnable getAcknowledger() {
        return MeteringAlo.applyMetering(this.delegate.getAcknowledger(), this.meters, this.startedAtNano);
    }

    public Consumer<? super Throwable> getNacknowledger() {
        return MeteringAlo.applyMetering(this.delegate.getNacknowledger(), this.meters, this.startedAtNano);
    }

    private static Runnable applyMetering(Runnable acknowledger, AloMeters meters, long startedAtNano) {
        return () -> {
            try {
                acknowledger.run();
            }
            finally {
                meters.success(Duration.ofNanos(System.nanoTime() - startedAtNano));
            }
        };
    }

    private static Consumer<Throwable> applyMetering(Consumer<? super Throwable> nacknowledger, AloMeters meters, long startedAtNano) {
        return error -> {
            try {
                nacknowledger.accept((Throwable)error);
            }
            finally {
                meters.failure(Duration.ofNanos(System.nanoTime() - startedAtNano));
            }
        };
    }
}

