/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.core.Alo;
import io.atleon.core.AloSignalListenerFactory;
import io.atleon.micrometer.MeterFacade;
import io.atleon.micrometer.MeterKey;
import io.atleon.micrometer.Tagger;
import io.atleon.micrometer.TypeKey;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.observability.DefaultSignalListener;
import reactor.core.observability.SignalListener;
import reactor.core.publisher.SignalType;
import reactor.util.context.ContextView;

public abstract class MeteringAloSignalListenerFactory<T, K>
implements AloSignalListenerFactory<T, Void> {
    private final MeterRegistry meterRegistry;
    private final String name;

    protected MeteringAloSignalListenerFactory(String name) {
        this((MeterRegistry)Metrics.globalRegistry, name);
    }

    protected MeteringAloSignalListenerFactory(MeterRegistry meterRegistry, String name) {
        this.meterRegistry = meterRegistry;
        this.name = name;
    }

    public Void initializePublisherState(Publisher<? extends Alo<T>> source) {
        return null;
    }

    public SignalListener<Alo<T>> createListener(Publisher<? extends Alo<T>> source, ContextView listenerContext, Void publisherContext) {
        return new MeteringAloSignalListener<T, K>(this.meterRegistry, this.name, this.keyExtractor(), this.tagger());
    }

    protected abstract Function<? super T, K> keyExtractor();

    protected abstract Tagger<? super K> tagger();

    private static final class MeteringAloSignalListener<T, K>
    extends DefaultSignalListener<Alo<T>> {
        private final MeterFacade<TypeKey<SignalType, K>> meterFacade;
        private final Function<? super T, K> keyExtractor;
        private final Tagger<? super K> tagger;

        public MeteringAloSignalListener(MeterRegistry meterRegistry, String name, Function<? super T, K> keyExtractor, Tagger<? super K> tagger) {
            this.meterFacade = MeterFacade.create(meterRegistry, it -> new MeterKey(name, this.toTags((TypeKey<SignalType, K>)it)));
            this.keyExtractor = keyExtractor;
            this.tagger = tagger;
        }

        public void doOnRequest(long requested) {
            this.meterFacade.counter(new TypeKey(SignalType.REQUEST)).increment();
        }

        public void doOnCancel() {
            this.meterFacade.counter(new TypeKey(SignalType.CANCEL)).increment();
        }

        public void doOnNext(Alo<T> value) {
            K key = this.keyExtractor.apply(value.get());
            this.meterFacade.counter(new TypeKey<SignalType, K>(SignalType.ON_NEXT, key)).increment();
        }

        public void doOnError(Throwable error) {
            this.meterFacade.counter(new TypeKey(SignalType.ON_ERROR)).increment();
        }

        private Tags toTags(TypeKey<SignalType, K> typeKey) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(Tag.of((String)"signal_type", (String)typeKey.typeName()));
            this.tagger.base().forEach(tags::add);
            typeKey.mapKey(this.tagger::extract).ifPresent(extractedTags -> extractedTags.forEach(tags::add));
            return Tags.of(tags);
        }
    }
}

