/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.micrometer.AuditedMetricRegistry;
import io.atleon.micrometer.MeterKey;
import io.atleon.util.ConfigLoading;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaMetricsReporter
implements MetricsReporter {
    public static final String CONFIG_PREFIX = "metric.reporter.";
    public static final String FILTER_NAMES_INCLUSION_CONFIG = "metric.reporter.filter.names.inclusion";
    public static final String FILTER_NAMES_CONFIG = "metric.reporter.filter.names";
    protected static final String CLIENT_ID_TAG = "client-id";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKafkaMetricsReporter.class);
    private static final double ABSENT_EVALUATION = Double.NaN;
    private static final AuditedMetricRegistry<AbstractKafkaMetricsReporter, KafkaMetric, Double> AUDITED_METRIC_REGISTRY = new AuditedMetricRegistry<AbstractKafkaMetricsReporter, KafkaMetric, Double>(AbstractKafkaMetricsReporter::extractMeterValue, Double.NaN);
    protected MeterRegistry meterRegistry = Metrics.globalRegistry;
    private FilterInclusion filteredMetricNamesInclusion = FilterInclusion.BLOCKLIST;
    private Collection<String> filteredMetricNames = Collections.emptySet();

    public void configure(Map<String, ?> configs) {
        this.meterRegistry = this.createMeterRegistry(configs);
        this.filteredMetricNamesInclusion = AbstractKafkaMetricsReporter.loadFilterInclusion(configs).orElse(FilterInclusion.BLOCKLIST);
        this.filteredMetricNames = ConfigLoading.loadSetOfStringOrEmpty(configs, (String)FILTER_NAMES_CONFIG);
    }

    public final void init(List<KafkaMetric> metrics) {
        metrics.forEach(this::metricChange);
    }

    public final void metricChange(KafkaMetric metric) {
        String extractedMetricName = this.extractMetricName(metric);
        if (this.shouldReportMetric(metric, extractedMetricName)) {
            this.registerMetric(this.createMeterKey(metric, extractedMetricName), metric);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
        AUDITED_METRIC_REGISTRY.unregister(this.createMeterKey(metric, this.extractMetricName(metric)), this);
    }

    public void close() {
        AUDITED_METRIC_REGISTRY.unregister(this);
    }

    protected MeterRegistry createMeterRegistry(Map<String, ?> configs) {
        return Metrics.globalRegistry;
    }

    protected String extractMetricName(KafkaMetric metric) {
        return metric.metricName().name();
    }

    protected boolean shouldReportMetric(KafkaMetric metric, String extractedMetricName) {
        return FilterInclusion.ALLOWLIST.equals((Object)this.filteredMetricNamesInclusion) == this.filteredMetricNames.contains(extractedMetricName);
    }

    protected final MeterKey createMeterKey(KafkaMetric metric, String extractedMetricName) {
        return new MeterKey(this.extractMeterNamePrefix(metric) + extractedMetricName, this.extractTags(metric));
    }

    protected String extractMeterNamePrefix(KafkaMetric metric) {
        return "kafka." + metric.metricName().group() + ".";
    }

    protected Map<String, String> extractTags(KafkaMetric metric) {
        return metric.metricName().tags();
    }

    protected final void registerMetric(MeterKey meterKey, KafkaMetric metric) {
        MeterKey registeredMeterKey = AUDITED_METRIC_REGISTRY.register(meterKey, this, metric);
        if (this.meterRegistry.find(registeredMeterKey.getName()).tags(registeredMeterKey.getTags()).meter() == null) {
            AbstractKafkaMetricsReporter.registerGauge(this.meterRegistry, registeredMeterKey, metric);
        }
    }

    protected final double extractMeterValue(KafkaMetric metric) {
        return Optional.ofNullable(metric.metricValue()).filter(Number.class::isInstance).map(Number.class::cast).flatMap(this::extractMeterValue).orElse(Double.NaN);
    }

    protected Optional<Double> extractMeterValue(Number number) {
        return Optional.of(number.doubleValue());
    }

    protected static String removeUuids(String string) {
        return string.replaceAll("-?[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}", "");
    }

    protected static String removeUpToLastAndIncluding(String string, char toRemove) {
        return string.substring(string.lastIndexOf(toRemove) + 1);
    }

    private static Optional<FilterInclusion> loadFilterInclusion(Map<String, ?> configs) {
        Optional filterInclusion = ConfigLoading.loadParseable(configs, (String)FILTER_NAMES_INCLUSION_CONFIG, FilterInclusion.class, FilterInclusion::valueOf);
        return filterInclusion.map(AbstractKafkaMetricsReporter::sanitize);
    }

    private static FilterInclusion sanitize(FilterInclusion filterInclusion) {
        switch (filterInclusion) {
            case BLACKLIST: {
                return FilterInclusion.BLOCKLIST;
            }
            case WHITELIST: {
                return FilterInclusion.ALLOWLIST;
            }
        }
        return filterInclusion;
    }

    private static void registerGauge(MeterRegistry meterRegistry, MeterKey meterKey, KafkaMetric metric) {
        try {
            Gauge.builder((String)meterKey.getName(), (Object)meterKey, AUDITED_METRIC_REGISTRY::evaluate).description(metric.metricName().description()).tags(meterKey.getTags()).register(meterRegistry);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to register Gauge with key={}", (Object)meterKey, (Object)e);
        }
    }

    public static enum FilterInclusion {
        BLOCKLIST,
        ALLOWLIST,
        BLACKLIST,
        WHITELIST;

    }
}

