/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.core.Alo;
import io.atleon.core.AloDecorator;
import io.atleon.micrometer.AloMeters;
import io.atleon.micrometer.MeterFacade;
import io.atleon.micrometer.MeterKey;
import io.atleon.micrometer.MeteringAlo;
import io.atleon.micrometer.TypeKey;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Map;

public abstract class MeteringAloDecorator<T, K>
implements AloDecorator<T> {
    private final MeterFacade<TypeKey<AloMeterType, K>> meterFacade;

    protected MeteringAloDecorator(String name) {
        this((MeterRegistry)Metrics.globalRegistry, name);
    }

    protected MeteringAloDecorator(MeterRegistry meterRegistry, String name) {
        this.meterFacade = MeterFacade.create(meterRegistry, it -> this.toMeterKey(name, (TypeKey<AloMeterType, K>)it));
    }

    public void configure(Map<String, ?> properties) {
        this.meterFacade.clear();
    }

    public final Alo<T> decorate(Alo<T> alo) {
        K key = this.extractKey(alo.get());
        return MeteringAlo.start(alo, this.newMeters(key));
    }

    protected abstract K extractKey(T var1);

    protected final AloMeters newMeters(K key) {
        return new AloMeters(this.meterFacade.timer(new TypeKey<AloMeterType, K>(AloMeterType.SUCCESS_TIMER, key)), this.meterFacade.timer(new TypeKey<AloMeterType, K>(AloMeterType.FAILURE_TIMER, key)));
    }

    protected final MeterKey toMeterKey(String name, TypeKey<AloMeterType, K> typeKey) {
        switch (typeKey.type()) {
            case SUCCESS_TIMER: {
                return new MeterKey(name + ".duration", Tags.of((String)"result", (String)"success").and(this.extractTags(typeKey.key())));
            }
            case FAILURE_TIMER: {
                return new MeterKey(name + ".duration", Tags.of((String)"result", (String)"failure").and(this.extractTags(typeKey.key())));
            }
        }
        throw new IllegalStateException("Unimplemented aloMeterType=" + (Object)((Object)typeKey.type()));
    }

    protected abstract Iterable<Tag> extractTags(K var1);

    private static enum AloMeterType {
        SUCCESS_TIMER,
        FAILURE_TIMER;

    }
}

