/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AcknowledgingCollection;
import io.atleon.core.AcknowledgingPublisher;
import io.atleon.core.Alo;
import io.atleon.util.Throwing;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

final class AloOps {
    private AloOps() {
    }

    public static <T, A extends Alo<T>> Predicate<A> filtering(Predicate<? super T> predicate, Consumer<? super A> negativeConsumer) {
        return alo -> {
            try {
                boolean result = predicate.test((Object)alo.get());
                if (!result) {
                    negativeConsumer.accept((Object)alo);
                }
                return result;
            }
            catch (Throwable error) {
                Alo.nacknowledge(alo, error);
                throw Throwing.propagate((Throwable)error);
            }
        };
    }

    public static <T, R> Function<Alo<T>, Alo<R>> mapping(Function<? super T, ? extends R> mapper) {
        return alo -> {
            try {
                return alo.map(mapper);
            }
            catch (Throwable error) {
                Alo.nacknowledge(alo, error);
                throw Throwing.propagate((Throwable)error);
            }
        };
    }

    public static <T, R> Function<Alo<T>, Collection<Alo<R>>> mappingToMany(Function<? super T, ? extends Collection<R>> mapper, Consumer<? super Alo<T>> emptyMappingConsumer) {
        return alo -> {
            try {
                Alo result = alo.map(mapper);
                if (((Collection)result.get()).isEmpty()) {
                    emptyMappingConsumer.accept((Object)alo);
                    return Collections.emptyList();
                }
                return AcknowledgingCollection.fromNonEmptyAloCollection(result);
            }
            catch (Throwable error) {
                Alo.nacknowledge(alo, error);
                throw Throwing.propagate((Throwable)error);
            }
        };
    }

    public static <T, R> Function<Alo<T>, Publisher<Alo<R>>> publishing(Function<? super T, ? extends Publisher<R>> mapper) {
        return alo -> {
            try {
                return AcknowledgingPublisher.fromAloPublisher(alo.map(mapper));
            }
            catch (Throwable error) {
                Alo.nacknowledge(alo, error);
                throw Throwing.propagate((Throwable)error);
            }
        };
    }

    public static <T> BinaryOperator<Alo<T>> reducing(BinaryOperator<T> reducer) {
        return (alo1, alo2) -> {
            try {
                return alo1.reduce(reducer, alo2);
            }
            catch (Throwable error) {
                Alo.nacknowledge(alo1, error);
                Alo.nacknowledge(alo2, error);
                throw Throwing.propagate((Throwable)error);
            }
        };
    }

    public static Runnable combineAcknowledgers(Iterable<? extends Runnable> acknowledgers) {
        return () -> acknowledgers.forEach(Runnable::run);
    }

    public static Consumer<? super Throwable> combineNacknowledgers(Iterable<? extends Consumer<? super Throwable>> nacknowledgers) {
        return error -> nacknowledgers.forEach(nacknowledger -> nacknowledger.accept(error));
    }

    public static Runnable combineAcknowledgers(Runnable acknowledger1, Runnable acknowledger2) {
        return () -> {
            acknowledger1.run();
            acknowledger2.run();
        };
    }

    public static Consumer<Throwable> combineNacknowledgers(Consumer<? super Throwable> nacknowledger1, Consumer<? super Throwable> nacknowledger2) {
        return error -> {
            nacknowledger1.accept((Throwable)error);
            nacknowledger2.accept((Throwable)error);
        };
    }
}

