/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.AloFlux;
import io.atleon.core.AloOps;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AloMono<T>
implements Publisher<Alo<T>> {
    private final Mono<Alo<T>> wrapped;

    AloMono(Mono<Alo<T>> wrapped) {
        this.wrapped = wrapped;
    }

    public static <T> AloMono<T> wrap(Publisher<Alo<T>> publisher) {
        return new AloMono<T>(Mono.from(publisher));
    }

    public Mono<Alo<T>> unwrap() {
        return this.wrapped;
    }

    public AloMono<T> doFirst(Runnable onFirst) {
        return new AloMono<T>(this.wrapped.doFirst(onFirst));
    }

    public AloMono<T> doOnNext(Consumer<? super T> onNext) {
        return new AloMono<T>(this.wrapped.doOnNext(alo -> onNext.accept((Object)alo.get())));
    }

    public AloMono<T> doOnError(Consumer<? super Throwable> onError) {
        return new AloMono<T>(this.wrapped.doOnError(onError));
    }

    public AloMono<T> filter(Predicate<? super T> predicate) {
        return new AloMono<T>(this.wrapped.filter(AloOps.filtering(predicate, Alo::acknowledge)));
    }

    public <V> AloMono<V> map(Function<? super T, ? extends V> mapper) {
        return new AloMono<T>(this.wrapped.map(AloOps.mapping(mapper)));
    }

    public <V> AloMono<V> flatMap(Function<? super T, Mono<V>> mapper) {
        return new AloMono<T>(this.wrapped.flatMap(AloOps.publishing(mapper).andThen(Mono::from)));
    }

    public <R, C extends Collection<R>> AloFlux<R> flatMapCollection(Function<? super T, ? extends C> mapper) {
        return new AloFlux(this.wrapped.flatMapIterable(AloOps.mappingToMany(mapper, Alo::acknowledge)));
    }

    public <V> AloFlux<V> flatMapMany(Function<? super T, ? extends Publisher<V>> mapper) {
        return new AloFlux(this.wrapped.flatMapMany(AloOps.publishing(mapper)));
    }

    public AloMono<T> delayUntil(Function<? super T, ? extends Publisher<?>> triggerProvider) {
        return new AloMono<T>(this.wrapped.delayUntil(alo -> (Publisher)triggerProvider.apply((Object)alo.get())));
    }

    public <V> Flux<V> transformToMono(Function<? super AloMono<T>, ? extends Publisher<V>> transformer) {
        return Flux.from(transformer.apply(this));
    }

    public <P> P as(Function<? super AloMono<T>, P> transformer) {
        return transformer.apply(this);
    }

    public Disposable subscribe() {
        return this.subscribe(Alo::acknowledge);
    }

    public Disposable subscribe(Consumer<? super Alo<? super T>> consumer) {
        return this.wrapped.subscribe(consumer);
    }

    public Disposable subscribe(Consumer<? super Alo<? super T>> consumer, Consumer<? super Throwable> errorConsumer) {
        return this.wrapped.subscribe(consumer, errorConsumer);
    }

    public void subscribe(Subscriber<? super Alo<T>> subscriber) {
        this.wrapped.subscribe(subscriber);
    }

    public <E extends Subscriber<? super Alo<T>>> E subscribeWith(E subscriber) {
        return (E)this.wrapped.subscribeWith(subscriber);
    }
}

