/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Function;

public abstract class UuidHashGroupExtractor<T>
implements Function<T, Integer> {
    private final HashFunction hashFunction = Hashing.murmur3_32();
    private final int modulus;

    public UuidHashGroupExtractor(int modulus) {
        this.modulus = modulus;
    }

    public static <T> UuidHashGroupExtractor<T> composed(Function<? super T, UUID> uuidExtractor, int modulus) {
        return new Composed<T>(uuidExtractor, modulus);
    }

    @Override
    public Integer apply(T t) {
        byte[] uuidBytes = this.extractUuidBytes(t);
        HashCode hash = this.hashFunction.hashBytes(uuidBytes);
        return Math.abs(hash.asInt() % this.modulus);
    }

    protected final byte[] extractUuidBytes(T t) {
        UUID uuid = this.extractUuid(t);
        ByteBuffer uuidBytes = ByteBuffer.allocate(16);
        uuidBytes.putLong(uuid == null ? 0L : uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid == null ? 0L : uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    protected abstract UUID extractUuid(T var1);

    private static final class Composed<T>
    extends UuidHashGroupExtractor<T> {
        private final Function<? super T, UUID> extractor;

        public Composed(Function<? super T, UUID> extractor, int modulus) {
            super(modulus);
            this.extractor = extractor;
        }

        @Override
        protected UUID extractUuid(T t) {
            return this.extractor.apply(t);
        }
    }
}

