/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ActivityEnforcementConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ActivityEnforcingTransformer<T>
implements Function<Publisher<T>, Publisher<T>> {
    private final ActivityEnforcementConfig config;

    ActivityEnforcingTransformer(ActivityEnforcementConfig config) {
        this.config = config;
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        return this.config.isEnabled() ? Flux.from(publisher).transformDeferred(this::enforceActivity) : publisher;
    }

    private Flux<T> enforceActivity(Publisher<T> publisher) {
        AtomicLong lastActiveEpochMilli = new AtomicLong(System.currentTimeMillis());
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = this.createInactivityError(lastActiveEpochMilli::get);
        publisherArray[1] = publisher;
        return Flux.merge((Publisher[])publisherArray).doOnEach(signal -> lastActiveEpochMilli.set(System.currentTimeMillis()));
    }

    private Mono<T> createInactivityError(LongSupplier lastActiveEpochMilli) {
        return Flux.interval((Duration)this.config.getDelay(), (Duration)this.config.getInterval()).map(i -> lastActiveEpochMilli.getAsLong()).filter(this::hasBecomeInactiveSince).next().flatMap(this::createInactivityError);
    }

    private boolean hasBecomeInactiveSince(long lastActiveEpochMilli) {
        Duration durationSinceLastActivity = Duration.ofMillis(System.currentTimeMillis() - lastActiveEpochMilli);
        return durationSinceLastActivity.compareTo(this.config.getMaxInactivity()) > 0;
    }

    private Mono<T> createInactivityError(long lastActiveEpochMilli) {
        return Mono.error((Throwable)new InactiveStreamException(this.config.getName(), this.config.getMaxInactivity(), lastActiveEpochMilli));
    }

    private static final class InactiveStreamException
    extends TimeoutException {
        public InactiveStreamException(String name, Duration maxInactivity, long lastActiveEpochMilli) {
            super(String.format("Stream=%s has been inactive for longer than duration=%s with lastActive=%s", name, maxInactivity, Instant.ofEpochMilli(lastActiveEpochMilli)));
        }
    }
}

