/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.time.Duration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public final class ErrorEmitter<T> {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorEmitter.class);
    private final Duration timeout;
    private final Sinks.Empty<T> sink = Sinks.empty();

    private ErrorEmitter(Duration timeout) {
        this.timeout = timeout;
    }

    public static <T> ErrorEmitter<T> create() {
        return new ErrorEmitter<T>(DEFAULT_TIMEOUT);
    }

    public static <T> ErrorEmitter<T> create(Duration timeout) {
        return new ErrorEmitter<T>(timeout);
    }

    public Flux<T> applyTo(Publisher<T> publisher) {
        return Flux.from(publisher).mergeWith((Publisher)this.sink.asMono());
    }

    public void safelyEmit(Throwable error) {
        try {
            this.sink.emitError(error, Sinks.EmitFailureHandler.busyLooping((Duration)this.timeout));
        }
        catch (Sinks.EmissionException emissionException) {
            LOGGER.info("Failed to emit error due to reason={}", (Object)emissionException.getReason());
        }
    }
}

