/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class AloErrorDelegatingMapper<T>
implements Function<Alo<T>, Alo<T>> {
    private final BiFunction<? super T, ? super Throwable, ? extends Publisher<?>> delegator;

    AloErrorDelegatingMapper(BiFunction<? super T, ? super Throwable, ? extends Publisher<?>> delegator) {
        this.delegator = delegator;
    }

    @Override
    public Alo<T> apply(Alo<T> alo) {
        return alo.propagator().create(alo.get(), alo.getAcknowledger(), error -> this.delegateAloError(alo, (Throwable)error));
    }

    private void delegateAloError(Alo<T> alo, Throwable error) {
        alo.runInContext(() -> this.delegateError(alo.get(), error).subscribe(__ -> {}, alo.getNacknowledger(), alo.getAcknowledger()));
    }

    private Mono<Void> delegateError(T t, Throwable error) {
        try {
            return Mono.when((Publisher[])new Publisher[]{this.delegator.apply(t, error)}).onErrorMap(delegateError -> AloErrorDelegatingMapper.consolidateErrors(error, delegateError));
        }
        catch (Throwable delegateError2) {
            return Mono.error((Throwable)AloErrorDelegatingMapper.consolidateErrors(error, delegateError2));
        }
    }

    private static Throwable consolidateErrors(Throwable originalError, Throwable delegateError) {
        if (originalError != delegateError) {
            originalError.addSuppressed(delegateError);
        }
        return originalError;
    }
}

