/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.SenderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.BaseSubscriber;

public class DefaultAloSenderResultSubscriber<T extends SenderResult>
extends BaseSubscriber<Alo<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAloSenderResultSubscriber.class);

    protected final void hookOnNext(Alo<T> value) {
        SenderResult senderResult = (SenderResult)value.get();
        if (this.shouldAcknowledge(senderResult)) {
            Alo.acknowledge(value);
        } else {
            this.hookBeforeNacknowledge(senderResult);
            Alo.nacknowledge(value, SenderResult.toError(senderResult));
        }
    }

    protected boolean shouldAcknowledge(T senderResult) {
        return !senderResult.isFailure();
    }

    protected void hookBeforeNacknowledge(T senderResult) {
        Throwable failureCause = senderResult.failureCause().orElse(null);
        LOGGER.warn("SenderResult of type={} is failed", (Object)senderResult.getClass().getSimpleName(), (Object)failureCause);
    }
}

