/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.SynchronousSink;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

interface AloFailureStrategy {
    public static final AloFailureStrategy EMIT = new Emit((__, error) -> true);
    public static final AloFailureStrategy DELEGATE = new Delegate((__, error) -> true);

    public static AloFailureStrategy choose(Subscriber<?> subscriber) {
        if (subscriber instanceof CoreSubscriber) {
            return AloFailureStrategy.choose((ContextView)((CoreSubscriber)CoreSubscriber.class.cast(subscriber)).currentContext());
        }
        return AloFailureStrategy.choose((ContextView)Context.empty());
    }

    public static AloFailureStrategy choose(SynchronousSink<?> sink) {
        return AloFailureStrategy.choose(sink.contextView());
    }

    public static AloFailureStrategy choose(ContextView contextView) {
        return (AloFailureStrategy)contextView.getOrDefault(AloFailureStrategy.class, (Object)AloFailureStrategy.emit());
    }

    public boolean process(Alo<?> var1, Throwable var2, Consumer<Throwable> var3);

    public static AloFailureStrategy emit() {
        return EMIT;
    }

    public static AloFailureStrategy emit(BiPredicate<Object, ? super Throwable> errorPredicate) {
        return new Emit(errorPredicate);
    }

    public static AloFailureStrategy delegate() {
        return DELEGATE;
    }

    public static AloFailureStrategy delegate(BiPredicate<Object, ? super Throwable> errorPredicate) {
        return new Delegate(errorPredicate);
    }

    public static class Delegate
    implements AloFailureStrategy {
        private final BiPredicate<Object, ? super Throwable> errorPredicate;

        private Delegate(BiPredicate<Object, ? super Throwable> errorPredicate) {
            this.errorPredicate = errorPredicate;
        }

        @Override
        public boolean process(Alo<?> alo, Throwable error, Consumer<Throwable> errorEmitter) {
            if (this.errorPredicate.test(alo.get(), error)) {
                return false;
            }
            Alo.acknowledge(alo);
            return true;
        }
    }

    public static class Emit
    implements AloFailureStrategy {
        private final BiPredicate<Object, ? super Throwable> errorPredicate;

        private Emit(BiPredicate<Object, ? super Throwable> errorPredicate) {
            this.errorPredicate = errorPredicate;
        }

        @Override
        public boolean process(Alo<?> alo, Throwable error, Consumer<Throwable> errorEmitter) {
            if (this.errorPredicate.test(alo.get(), error)) {
                errorEmitter.accept(error);
            } else {
                Alo.acknowledge(alo);
            }
            return true;
        }
    }
}

