/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.BaseSubscriber;

public final class Adapters {
    private Adapters() {
    }

    public static <T> Subscriber<T> toSubscriber(Consumer<T> consumer) {
        return new ConsumingSubscriber<T>(consumer);
    }

    private static final class ConsumingSubscriber<T>
    extends BaseSubscriber<T> {
        private final Consumer<T> consumer;

        ConsumingSubscriber(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        protected void hookOnNext(T value) {
            this.consumer.accept(value);
        }
    }
}

