/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.AloFactory;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

final class AcknowledgingCollection<T>
extends AbstractCollection<Alo<T>> {
    private final Alo<Collection<T>> aloCollection;
    private final AloFactory<T> aloFactory;
    private final Set<T> unacknowledged;

    private AcknowledgingCollection(Alo<Collection<T>> aloCollection) {
        this.aloCollection = aloCollection;
        this.aloFactory = aloCollection.propagator();
        this.unacknowledged = AcknowledgingCollection.copyToIdentityHashSet(aloCollection.get());
    }

    public static <T> Collection<Alo<T>> fromNonEmptyAloCollection(Alo<Collection<T>> aloCollection) {
        return new AcknowledgingCollection<T>(aloCollection);
    }

    @Override
    public String toString() {
        return "AcknowledgingCollection(" + this.aloCollection.get() + ")";
    }

    @Override
    public Iterator<Alo<T>> iterator() {
        final Iterator<T> iterator = this.aloCollection.get().iterator();
        return new Iterator<Alo<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Alo<T> next() {
                return AcknowledgingCollection.this.wrap(iterator.next());
            }
        };
    }

    @Override
    public int size() {
        return this.aloCollection.get().size();
    }

    private Alo<T> wrap(T value) {
        return this.aloFactory.create(value, () -> {
            Set<T> set = this.unacknowledged;
            synchronized (set) {
                if (this.unacknowledged.remove(value) && this.unacknowledged.isEmpty()) {
                    Alo.acknowledge(this.aloCollection);
                }
            }
        }, error -> {
            Set<T> set = this.unacknowledged;
            synchronized (set) {
                if (this.unacknowledged.contains(value)) {
                    this.unacknowledged.clear();
                    Alo.nacknowledge(this.aloCollection, error);
                }
            }
        });
    }

    private static <T> Set<T> copyToIdentityHashSet(Collection<T> collection) {
        Set set = Collections.newSetFromMap(new IdentityHashMap(collection.size()));
        set.addAll(collection);
        return set;
    }
}

